/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack;

import architectury_inject_palladium_common_b6d907996b23480397cacb2ac352c113_c08ee70f648eab495b16936f54fbdd444de5ef7c62b43dcd14950ea91d71df97palladium4321201devjar.PlatformMethods;
import com.google.gson.JsonObject;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.stream.Collectors;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.FolderRepositorySource;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Unit;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.PackData;
import net.threetag.palladium.addonpack.forge.AddonPackManagerImpl;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.log.AddonPackLogEntry;
import net.threetag.palladium.addonpack.parser.AccessoryParser;
import net.threetag.palladium.addonpack.parser.AccessorySlotParser;
import net.threetag.palladium.addonpack.parser.ArmorMaterialParser;
import net.threetag.palladium.addonpack.parser.BlockParser;
import net.threetag.palladium.addonpack.parser.CreativeModeTabParser;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.addonpack.parser.ParticleTypeParser;
import net.threetag.palladium.addonpack.parser.PoiTypeParser;
import net.threetag.palladium.addonpack.parser.SuitSetParser;
import net.threetag.palladium.addonpack.parser.ToolTierParser;
import net.threetag.palladium.addonpack.parser.VillagerProfessionParser;
import net.threetag.palladium.addonpack.parser.VillagerTradeParser;
import net.threetag.palladium.client.screen.AddonPackLogScreen;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.ScreenEvents;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.NotNull;

public class AddonPackManager {
    private static AddonPackManager INSTANCE;
    public static PackType PACK_TYPE;
    public static boolean IGNORE_INJECT;
    public static ItemParser ITEM_PARSER;
    private static CompletableFuture<AddonPackManager> loaderFuture;
    private final Map<String, PackData> packs = new HashMap<String, PackData>();
    private final ReloadableResourceManager resourceManager;
    private final RepositorySource folderPackFinder;
    private final PackRepository packList;
    private QueueableExecutor mainThreadExecutor;

    public static AddonPackManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AddonPackManager();
        }
        return INSTANCE;
    }

    public static void startLoading() {
        Palladium.LOGGER.info("Starting addonpack initialisation...");
        loaderFuture = AddonPackManager.getInstance().beginLoading(Util.m_183991_());
    }

    public static void waitForLoading() {
        AddonPackManager.getInstance().waitForLoading(loaderFuture);
        loaderFuture = null;
    }

    private AddonPackManager() {
        RepositorySource[] repositorySourceArray;
        IGNORE_INJECT = true;
        this.resourceManager = new ReloadableResourceManager(AddonPackManager.getPackType());
        this.folderPackFinder = new FolderRepositorySource(this.getLocation(), AddonPackManager.getPackType(), PackSource.f_10527_);
        RepositorySource modSource = AddonPackManager.getModRepositorySource();
        if (modSource == null) {
            RepositorySource[] repositorySourceArray2 = new RepositorySource[1];
            repositorySourceArray = repositorySourceArray2;
            repositorySourceArray2[0] = this.folderPackFinder;
        } else {
            RepositorySource[] repositorySourceArray3 = new RepositorySource[2];
            repositorySourceArray3[0] = this.folderPackFinder;
            repositorySourceArray = repositorySourceArray3;
            repositorySourceArray3[1] = modSource;
        }
        RepositorySource[] sources = repositorySourceArray;
        this.packList = new PackRepository(sources);
        IGNORE_INJECT = false;
        this.resourceManager.m_7217_((PreparableReloadListener)new CreativeModeTabParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new ArmorMaterialParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new ToolTierParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new BlockParser());
        ITEM_PARSER = new ItemParser();
        this.resourceManager.m_7217_((PreparableReloadListener)ITEM_PARSER);
        this.resourceManager.m_7217_((PreparableReloadListener)new SuitSetParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new ParticleTypeParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new PoiTypeParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new VillagerProfessionParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new VillagerTradeParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new AccessorySlotParser());
        this.resourceManager.m_7217_((PreparableReloadListener)new AccessoryParser());
    }

    public Path getLocation() {
        Path folder = Platform.getFolder().resolve("addonpacks");
        File file = folder.toFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("Could not create addonpacks directory! Please create the directory yourself, or make sure the name is not taken by a file and you have permission to create directories.");
        }
        return folder;
    }

    public RepositorySource getWrappedPackFinder() {
        return AddonPackManager.getWrappedPackFinder(this.folderPackFinder);
    }

    public Collection<PackData> getPacks() {
        return this.packs.values();
    }

    public PackData getPackData(String id) {
        return this.packs.get(id);
    }

    public PackRepository getPackList() {
        return this.packList;
    }

    public static RepositorySource getWrappedPackFinder(RepositorySource folderPackFinder) {
        return infoConsumer -> folderPackFinder.m_7686_(pack -> {
            pack.f_10401_ = "addonpack:" + pack.m_10446_();
            pack.f_10407_ = true;
            infoConsumer.accept(pack);
        });
    }

    public static PackType getPackType() {
        PackType client = PackType.CLIENT_RESOURCES;
        return PACK_TYPE;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static RepositorySource getModRepositorySource() {
        return AddonPackManagerImpl.getModRepositorySource();
    }

    public CompletableFuture<AddonPackManager> beginLoading(Executor backgroundExecutor) {
        this.packList.m_10506_();
        this.packList.m_10509_(this.packList.m_10514_());
        this.packs.clear();
        this.packList.m_10519_().forEach(pack -> {
            try {
                InputStream stream = (InputStream)pack.m_10445_().m_8017_(new String[]{"pack.mcmeta"}).m_247737_();
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                JsonObject jsonobject = GsonHelper.m_13859_((Reader)bufferedreader);
                PackData packData = PackData.fromJSON(jsonobject);
                if (packData == null) {
                    bufferedreader.close();
                    stream.close();
                    Palladium.LOGGER.info("Skipping " + pack.m_10446_() + " as it's not been marked as an addonpack");
                }
                if (this.packs.containsKey(packData.getId())) {
                    bufferedreader.close();
                    stream.close();
                    throw new RuntimeException("Duplicate addonpack: " + packData.getId());
                }
                this.packs.put(packData.getId(), packData);
                bufferedreader.close();
                stream.close();
            }
            catch (Exception e) {
                AddonPackLog.error(e.getLocalizedMessage(), new Object[0]);
            }
        });
        HashMap<PackData, List> dependencyConflicts = new HashMap<PackData, List>();
        for (PackData pack2 : this.packs.values()) {
            for (PackData.Dependency dependency : pack2.getDependenciesFor(PlatformMethods.getCurrentTarget())) {
                if (dependency.isValid()) continue;
                dependencyConflicts.computeIfAbsent(pack2, p -> new ArrayList()).add(dependency);
            }
        }
        if (!dependencyConflicts.isEmpty()) {
            ArrayList<CallSite> test = new ArrayList<CallSite>();
            for (Map.Entry entry : dependencyConflicts.entrySet()) {
                for (PackData.Dependency dependency : (List)entry.getValue()) {
                    test.add((CallSite)((Object)("Pack " + ((PackData)entry.getKey()).getId() + " requires " + dependency.getId() + " " + Arrays.toString(dependency.getVersionRequirements().toArray()))));
                }
            }
            if (Platform.isServer()) {
                throw new RuntimeException(Arrays.toString(test.toArray()));
            }
            ScreenEvents.OPENING.register((currentScreen, newScreen) -> {
                if (newScreen.get() instanceof TitleScreen) {
                    newScreen.set(new AddonPackLogScreen(dependencyConflicts.keySet().stream().map(packData -> {
                        StringBuilder s = new StringBuilder("Addon Pack '" + packData.getId() + "' requires ");
                        for (PackData.Dependency dependency : (List)dependencyConflicts.get(packData)) {
                            s.append(dependency.getId()).append(" ").append(Arrays.toString(dependency.getVersionRequirements().toArray())).append("; ");
                        }
                        s = new StringBuilder(s.substring(0, s.length() - 2));
                        return new AddonPackLogEntry(AddonPackLogEntry.Type.ERROR, s.toString());
                    }).collect(Collectors.toList()), null));
                }
                return EventResult.pass();
            });
        }
        this.mainThreadExecutor = new QueueableExecutor();
        return ((CompletableFuture)((CompletableFuture)this.resourceManager.m_142463_(backgroundExecutor, (Executor)this.mainThreadExecutor, CompletableFuture.completedFuture(Unit.INSTANCE), this.packList.m_10525_()).m_7237_().whenComplete((unit, throwable) -> {
            if (throwable != null) {
                this.resourceManager.close();
                AddonPackLog.error(throwable.getMessage(), new Object[0]);
            }
        })).thenRun(this.mainThreadExecutor::finish)).thenApply(unit -> this);
    }

    private void finish() {
        Palladium.LOGGER.info("Finished addonpack initialisation!");
    }

    public void waitForLoading(CompletableFuture<AddonPackManager> loaderFuture) {
        try {
            while (!loaderFuture.isDone()) {
                this.mainThreadExecutor.runQueue();
                this.mainThreadExecutor.waitForTasks();
            }
            this.mainThreadExecutor.runQueue();
            loaderFuture.get().finish();
        }
        catch (InterruptedException e) {
            Palladium.LOGGER.error("Addonpack loader future interrupted!");
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            throw new ReportedException(CrashReport.m_127521_((Throwable)cause, (String)"Error loading addonpacks"));
        }
    }

    static {
        IGNORE_INJECT = false;
    }

    public static class QueueableExecutor
    implements Executor {
        private final Thread thread = Thread.currentThread();
        private final ConcurrentLinkedQueue<Runnable> queue = new ConcurrentLinkedQueue();
        private final Semaphore sem = new Semaphore(1);

        public boolean isSameThread() {
            return Thread.currentThread() == this.thread;
        }

        @Override
        public void execute(@NotNull Runnable command) {
            if (!this.isSameThread()) {
                this.queue.add(command);
                this.sem.release();
            } else {
                command.run();
            }
        }

        public void runQueue() {
            if (!this.isSameThread()) {
                throw new IllegalStateException("This method must be called in the main thread.");
            }
            while (this.queue.size() > 0) {
                Runnable run = this.queue.poll();
                if (run == null) continue;
                run.run();
            }
        }

        public void finish() {
            this.sem.release();
        }

        public void waitForTasks() throws InterruptedException {
            this.sem.acquire();
        }
    }
}

