/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.addonpack.AddonPackManager;
import net.threetag.palladium.addonpack.version.SemanticVersion;
import net.threetag.palladium.addonpack.version.Version;
import net.threetag.palladium.addonpack.version.VersionInterval;
import net.threetag.palladium.addonpack.version.VersionParser;
import net.threetag.palladium.addonpack.version.VersionParsingException;
import net.threetag.palladium.addonpack.version.VersionPredicate;
import net.threetag.palladiumcore.util.Platform;

public final class PackData {
    private final String id;
    private final Version version;
    private final Map<String, List<Dependency>> dependencies;
    private JsonObject customData = new JsonObject();

    public PackData(String id, Version version, Map<String, List<Dependency>> dependencies) {
        this.id = id;
        this.version = version;
        this.dependencies = dependencies;
    }

    public List<Dependency> getDependenciesFor(String platform) {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        if (this.dependencies.containsKey("common")) {
            dependencies.addAll((Collection)this.dependencies.get("common"));
        }
        if (this.dependencies.containsKey(platform)) {
            dependencies.addAll((Collection<Dependency>)this.dependencies.get(platform));
        }
        return dependencies;
    }

    public static PackData fromJSON(JsonObject json) throws VersionParsingException, JsonParseException {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)"pack")) {
            return null;
        }
        JsonObject pack = GsonHelper.m_13930_((JsonObject)json, (String)"pack");
        if (!GsonHelper.m_13900_((JsonObject)pack, (String)"id") || !GsonHelper.m_13900_((JsonObject)pack, (String)"version")) {
            return null;
        }
        String id = GsonHelper.m_13906_((JsonObject)pack, (String)"id");
        SemanticVersion version = VersionParser.parseSemantic(GsonHelper.m_13906_((JsonObject)pack, (String)"version"));
        HashMap<String, List<Dependency>> dependenciesMap = new HashMap<String, List<Dependency>>();
        if (GsonHelper.m_13900_((JsonObject)json, (String)"dependencies")) {
            JsonObject dependencies = GsonHelper.m_13930_((JsonObject)json, (String)"dependencies");
            for (int i = 0; i < 3; ++i) {
                String type;
                String string = i == 0 ? "common" : (type = i == 1 ? "forge" : "fabric");
                if (!GsonHelper.m_13900_((JsonObject)dependencies, (String)type)) continue;
                JsonObject typedDependency = GsonHelper.m_13930_((JsonObject)dependencies, (String)type);
                for (Map.Entry entry : typedDependency.entrySet()) {
                    ArrayList<String> matcherStringList = new ArrayList<String>();
                    if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                        matcherStringList.add(((JsonElement)entry.getValue()).getAsString());
                    } else if (((JsonElement)entry.getValue()).isJsonArray()) {
                        for (JsonElement versionJson : ((JsonElement)entry.getValue()).getAsJsonArray()) {
                            matcherStringList.add(versionJson.getAsString());
                        }
                    } else {
                        throw new JsonParseException("Version dependency must be either a string or an array of strings");
                    }
                    dependenciesMap.computeIfAbsent(type, s -> new ArrayList()).add(new Dependency((String)entry.getKey(), matcherStringList));
                }
            }
        }
        PackData packData = new PackData(id, version, dependenciesMap);
        if (GsonHelper.m_13900_((JsonObject)json, (String)"custom")) {
            packData.setCustomData(GsonHelper.m_13930_((JsonObject)json, (String)"custom"));
        }
        return packData;
    }

    public String getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public Map<String, List<Dependency>> getDependencies() {
        return this.dependencies;
    }

    public JsonObject getCustomData() {
        return this.customData;
    }

    public void setCustomData(JsonObject customData) {
        this.customData = customData;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PackData that = (PackData)obj;
        return Objects.equals(this.id, that.id) && Objects.equals(this.version, that.version) && Objects.equals(this.dependencies, that.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.version, this.dependencies);
    }

    public String toString() {
        return "PackData[id=" + this.id + ", version=" + String.valueOf(this.version) + ", dependencies=" + String.valueOf(this.dependencies) + "]";
    }

    public static class Dependency {
        private final String id;
        private final boolean isAddonPack;
        private final List<String> matcherStringList;
        private final Collection<VersionPredicate> ranges;

        public Dependency(String id, List<String> matcherStringList) throws VersionParsingException {
            if (id.startsWith("pack:")) {
                this.id = id.substring("pack:".length());
                this.isAddonPack = true;
            } else {
                this.id = id;
                this.isAddonPack = false;
            }
            this.matcherStringList = matcherStringList;
            this.ranges = VersionPredicate.parse(this.matcherStringList);
        }

        public String getId() {
            return this.id;
        }

        public boolean isAddonPack() {
            return this.isAddonPack;
        }

        public boolean matches(Version version) {
            for (VersionPredicate predicate : this.ranges) {
                if (!predicate.test(version)) continue;
                return true;
            }
            return false;
        }

        public boolean isValid() {
            if (this.isAddonPack) {
                PackData packData = AddonPackManager.getInstance().getPackData(this.id);
                if (packData == null) {
                    return false;
                }
                return this.matches(packData.getVersion());
            }
            Platform.Mod mod = Platform.getMod((String)this.id);
            if (mod == null) {
                return false;
            }
            try {
                SemanticVersion version = VersionParser.parseSemantic(mod.version());
                return this.matches(version);
            }
            catch (VersionParsingException e) {
                e.printStackTrace();
                return false;
            }
        }

        public Collection<VersionPredicate> getVersionRequirements() {
            return this.ranges;
        }

        public List<VersionInterval> getVersionIntervals() {
            List<VersionInterval> ret = Collections.emptyList();
            for (VersionPredicate predicate : this.ranges) {
                ret = VersionInterval.or(ret, predicate.getInterval());
            }
            return ret;
        }
    }
}

