/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.builder;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil;
import net.threetag.palladium.item.AddonItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.RegistrySynonymsHandler;
import net.threetag.palladium.util.Utils;
import net.threetag.palladiumcore.registry.CreativeModeTabRegistry;
import org.jetbrains.annotations.Nullable;

public class ItemBuilder
extends AddonBuilder<Item> {
    private final JsonObject json;
    private ResourceLocation typeSerializerId = null;
    private Integer maxStackSize = null;
    private Integer maxDamage = null;
    private Boolean isFireResistant = null;
    private final List<ItemParser.PlacedTabPlacement> creativeModeTabs = new ArrayList<ItemParser.PlacedTabPlacement>();
    private Rarity rarity = null;
    private List<Component> tooltipLines = null;
    private Multimap<ResourceLocation, AttributeModifier> attributeModifiersAllSlots;
    private Map<PlayerSlot, Multimap<ResourceLocation, AttributeModifier>> attributeModifiers;
    private FoodProperties foodProperties = null;
    private IAddonItem.RenderLayerContainer renderLayerContainer = null;
    private boolean registerCurioTrinket = false;
    private boolean shouldRenderModel = true;

    public ItemBuilder(ResourceLocation id, JsonObject json) {
        super(id);
        this.json = json;
    }

    @Override
    protected Item create() {
        ItemParser.ItemTypeSerializer serializer;
        Item.Properties properties = new Item.Properties();
        if (this.maxDamage != null && this.maxDamage != 0) {
            Utils.ifNotNull(this.maxDamage, arg_0 -> ((Item.Properties)properties).m_41503_(arg_0));
        }
        if (this.maxStackSize != null && this.maxStackSize != 64) {
            Utils.ifNotNull(this.maxStackSize, arg_0 -> ((Item.Properties)properties).m_41487_(arg_0));
        }
        Utils.ifNotNull(this.rarity, arg_0 -> ((Item.Properties)properties).m_41497_(arg_0));
        Utils.ifNotNull(this.rarity, arg_0 -> ((Item.Properties)properties).m_41497_(arg_0));
        Utils.ifTrue(this.isFireResistant, () -> ((Item.Properties)properties).m_41486_());
        properties.m_41489_(this.foodProperties);
        if (this.typeSerializerId == null) {
            this.typeSerializerId = ItemParser.FALLBACK_SERIALIZER;
        }
        if ((serializer = ItemParser.getTypeSerializer(this.typeSerializerId)) == null) {
            AddonPackLog.warning("Unknown item type '" + String.valueOf(this.typeSerializerId) + "', falling back to '" + String.valueOf(ItemParser.FALLBACK_SERIALIZER) + "'", new Object[0]);
        }
        IAddonItem item = serializer != null ? serializer.parse(this.json, properties) : new AddonItem(properties);
        Utils.ifNotNull(this.tooltipLines, item::setTooltip);
        if (this.attributeModifiers != null) {
            for (PlayerSlot slot : this.attributeModifiers.keySet()) {
                for (ResourceLocation attributeId : this.attributeModifiers.get(slot).keySet()) {
                    Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(RegistrySynonymsHandler.getReplacement(BuiltInRegistries.f_256951_, attributeId));
                    if (attribute != null) {
                        for (AttributeModifier attributeModifier : this.attributeModifiers.get(slot).get((Object)attributeId)) {
                            item.getAttributeContainer().add(slot, attribute, attributeModifier);
                        }
                        continue;
                    }
                    throw new JsonParseException("Unknown attribute '" + String.valueOf(attributeId) + "'");
                }
            }
        }
        if (this.attributeModifiersAllSlots != null) {
            for (ResourceLocation attributeId : this.attributeModifiersAllSlots.keySet()) {
                Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(RegistrySynonymsHandler.getReplacement(BuiltInRegistries.f_256951_, attributeId));
                if (attribute != null) {
                    for (AttributeModifier attributeModifier : this.attributeModifiersAllSlots.get((Object)attributeId)) {
                        item.getAttributeContainer().addForAllSlots(attribute, attributeModifier);
                    }
                    continue;
                }
                throw new JsonParseException("Unknown attribute '" + String.valueOf(attributeId) + "'");
            }
        }
        item.setRenderLayerContainer(this.renderLayerContainer);
        if (this.registerCurioTrinket) {
            CuriosTrinketsUtil.getInstance().registerCurioTrinket((Item)item, new CurioTrinket(item));
        }
        for (ItemParser.PlacedTabPlacement creativeModeTab : this.creativeModeTabs) {
            ResourceKey tabKey = ResourceKey.m_135785_((ResourceKey)Registries.f_279569_, (ResourceLocation)creativeModeTab.getTab());
            CreativeModeTabRegistry.addToTab((ResourceKey)tabKey, entries -> creativeModeTab.addToTab((CreativeModeTabRegistry.ItemGroupEntries)entries, (Item)item));
        }
        item.setShouldRenderModel(this.shouldRenderModel);
        return (Item)item;
    }

    public ItemBuilder type(ResourceLocation serializerId) {
        this.typeSerializerId = serializerId;
        return this;
    }

    public ItemBuilder maxStackSize(int stackSize) {
        this.maxStackSize = stackSize;
        return this;
    }

    public ItemBuilder maxDamage(int maxDamage) {
        this.maxDamage = maxDamage;
        return this;
    }

    public ItemBuilder creativeModeTab(ItemParser.PlacedTabPlacement tabPlacement) {
        this.creativeModeTabs.add(tabPlacement);
        return this;
    }

    public ItemBuilder rarity(Rarity rarity) {
        this.rarity = rarity;
        return this;
    }

    public ItemBuilder fireResistant(boolean isFireResistant) {
        this.isFireResistant = isFireResistant;
        return this;
    }

    public ItemBuilder tooltipLines(List<Component> tooltipLines) {
        this.tooltipLines = tooltipLines;
        return this;
    }

    public ItemBuilder addAttributeModifier(@Nullable PlayerSlot slot, ResourceLocation attributeId, AttributeModifier modifier) {
        this.registerCurioTrinket = true;
        if (slot == null) {
            if (this.attributeModifiersAllSlots == null) {
                this.attributeModifiersAllSlots = ArrayListMultimap.create();
            }
            this.attributeModifiersAllSlots.put((Object)attributeId, (Object)modifier);
            return this;
        }
        if (this.attributeModifiers == null) {
            this.attributeModifiers = new HashMap<PlayerSlot, Multimap<ResourceLocation, AttributeModifier>>();
        }
        this.attributeModifiers.computeIfAbsent(slot, equipmentSlot -> ArrayListMultimap.create()).put((Object)attributeId, (Object)modifier);
        return this;
    }

    public ItemBuilder setRenderLayerContainer(IAddonItem.RenderLayerContainer container) {
        this.renderLayerContainer = container;
        return this;
    }

    public ItemBuilder food(FoodProperties foodProperties) {
        this.foodProperties = foodProperties;
        return this;
    }

    public ItemBuilder shouldRenderModel(boolean shouldRender) {
        this.shouldRenderModel = shouldRender;
        return this;
    }

    public static class CurioTrinket
    implements net.threetag.palladium.compat.curiostinkets.CurioTrinket {
        private final IAddonItem item;

        public CurioTrinket(IAddonItem item) {
            this.item = item;
        }

        @Override
        public Multimap<Attribute, AttributeModifier> getModifiers(PlayerSlot slot, LivingEntity entity) {
            return this.item.getAttributeContainer().get(slot, (Multimap<Attribute, AttributeModifier>)ArrayListMultimap.create());
        }
    }
}

