/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.forge.AddonParserImpl;

public abstract class AddonParser<T>
extends SimpleJsonResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public final ResourceKey<? extends Registry<T>> resourceKey;

    public AddonParser(Gson gson, String string, ResourceKey<? extends Registry<T>> resourceKey) {
        super(gson, string);
        this.resourceKey = resourceKey;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.injectJsons(object);
        AtomicInteger i = new AtomicInteger();
        HashMap addonBuilders = new HashMap();
        HashMap loadingOrders = new HashMap();
        object.forEach((id, jsonElement) -> {
            try {
                if (id.m_135815_().equalsIgnoreCase("_loading_order")) {
                    loadingOrders.put(id.m_135827_(), this.parseLoadingOrder((JsonElement)jsonElement));
                } else {
                    addonBuilders.put(id, this.parse((ResourceLocation)id, (JsonElement)jsonElement));
                    i.getAndIncrement();
                }
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.m_127521_((Throwable)e, (String)("Error while parsing addonpack " + this.resourceKey.m_135782_().m_135815_() + " '" + String.valueOf(id) + "'"));
                CrashReportCategory reportCategory = crashReport.m_127516_("Addon " + this.resourceKey.m_135782_().m_135815_(), 1);
                reportCategory.m_128159_("Resource name", id);
                throw new ReportedException(crashReport);
            }
        });
        TreeMap sorted = new TreeMap((id1, id2) -> {
            if (id1.m_135827_().equals(id2.m_135827_())) {
                List order = (List)loadingOrders.get(id1.m_135827_());
                if (order == null) {
                    return id1.compareTo(id2);
                }
                if (order.contains(id1.m_135815_()) && !order.contains(id2.m_135815_())) {
                    return -1;
                }
                if (!order.contains(id1.m_135815_()) && order.contains(id2.m_135815_())) {
                    return 1;
                }
                if (!order.contains(id1.m_135815_()) && !order.contains(id2.m_135815_())) {
                    return id1.compareTo(id2);
                }
                return order.indexOf(id1.m_135815_()) - order.indexOf(id2.m_135815_());
            }
            return id1.compareTo(id2);
        });
        sorted.putAll(addonBuilders);
        for (AddonBuilder addonBuilder : sorted.values()) {
            AddonParser.register(this.resourceKey, addonBuilder);
            this.postRegister(addonBuilder);
        }
        AddonPackLog.info("Registered " + i.get() + " addonpack " + this.resourceKey.m_135782_().m_135815_(), new Object[0]);
    }

    public List<String> parseLoadingOrder(JsonElement jsonElement) {
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        LinkedList<String> list = new LinkedList<String>();
        for (JsonElement element : jsonArray) {
            list.add(element.getAsString());
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T> void register(ResourceKey<? extends Registry<T>> key, AddonBuilder<T> builder) {
        void var1_1;
        AddonParserImpl.register(key, var1_1);
    }

    public void postRegister(AddonBuilder<T> addonBuilder) {
    }

    public void injectJsons(Map<ResourceLocation, JsonElement> map) {
    }

    public abstract AddonBuilder<T> parse(ResourceLocation var1, JsonElement var2);
}

