/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.builder.CreativeModeTabBuilder;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;

public class CreativeModeTabParser
extends AddonParser<CreativeModeTab> {
    public CreativeModeTabParser() {
        super(AddonParser.GSON, "creative_mode_tabs", Registries.f_279569_);
    }

    @Override
    public AddonBuilder<CreativeModeTab> parse(ResourceLocation id, JsonElement jsonElement) {
        JsonObject json = GsonHelper.m_13918_((JsonElement)jsonElement, (String)"$");
        CreativeModeTabBuilder builder = new CreativeModeTabBuilder(id);
        builder.itemIconId(GsonUtil.getAsResourceLocation(json, "icon"));
        if (GsonHelper.m_13900_((JsonObject)json, (String)"title")) {
            builder.title((Component)Component.Serializer.m_130691_((JsonElement)json.get("title")));
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"items")) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)"items");
            for (JsonElement element : array) {
                builder.addItem(GsonUtil.convertToResourceLocation(element, "items[].$"));
            }
        }
        return builder;
    }

    public static HTMLBuilder documentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder().setDescription("Each creative mode tab goes into a seperate file into the 'addon/[namespace]/creative_mode_tabs' folder, which can then be used for items.");
        builder.addProperty("icon", Item.class).description("Icon for tab, can only be an item.").required().exampleJson((JsonElement)new JsonPrimitive("minecraft:trident"));
        builder.addProperty("title", Component.class).description("Custom title for the tab. Will fall back to a translation key based on the ID.").fallback(null).exampleJson((JsonElement)new JsonPrimitive("itemGroup.namespace.example"));
        JsonArray jsonArray = new JsonArray();
        jsonArray.add("minecraft:cactus");
        jsonArray.add("minecraft:bread");
        jsonArray.add("minecraft:stick");
        builder.addProperty("items", List.class).description("You can list your items for the tab in the correct order here.").fallback(null).exampleJson((JsonElement)jsonArray);
        return new HTMLBuilder(new ResourceLocation("palladium", "creative_mode_tabs"), "Creative Mode Tabs").add(HTMLBuilder.heading("Creative Mode Tabs")).addDocumentation(builder);
    }
}

