/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.client.dynamictexture.DefaultDynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;

public abstract class DynamicModelLayerLocation {
    public abstract ModelLayerLocation getModelLayer(DataContext var1);

    public static DynamicModelLayerLocation fromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new Static(GsonUtil.convertToModelLayerLocation(jsonElement, "$"));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            if (GsonHelper.m_13900_((JsonObject)json, (String)"variables")) {
                Dynamic location = new Dynamic(GsonHelper.m_13906_((JsonObject)json, (String)"base"));
                JsonObject variables = GsonHelper.m_13930_((JsonObject)json, (String)"variables");
                for (Map.Entry entry : variables.entrySet()) {
                    JsonObject variableJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    ResourceLocation variableId = GsonUtil.getAsResourceLocation(variableJson, "type");
                    ITextureVariableSerializer serializer = DynamicTextureManager.getTextureVariableSerializer(variableId);
                    if (serializer != null) {
                        ITextureVariable variable = serializer.parse(variableJson);
                        location.addVariable((String)entry.getKey(), variable);
                        continue;
                    }
                    AddonPackLog.error("Unknown texture variable '" + String.valueOf(variableId) + "'", new Object[0]);
                }
                return location;
            }
            return new Static(GsonUtil.getAsModelLayerLocation(json, "base"));
        }
        throw new JsonSyntaxException("Model layer must be a string or an object");
    }

    public static class Static
    extends DynamicModelLayerLocation {
        private final ModelLayerLocation modelLayer;

        public Static(ModelLayerLocation modelLayer) {
            this.modelLayer = modelLayer;
        }

        @Override
        public ModelLayerLocation getModelLayer(DataContext context) {
            return this.modelLayer;
        }
    }

    public static class Dynamic
    extends DynamicModelLayerLocation {
        private final String base;
        private final Map<String, ITextureVariable> textureVariableMap = Maps.newHashMap();

        public Dynamic(String base) {
            this.base = base;
        }

        public Dynamic addVariable(String name, ITextureVariable variable) {
            this.textureVariableMap.put(name, variable);
            return this;
        }

        @Override
        public ModelLayerLocation getModelLayer(DataContext context) {
            String model = DefaultDynamicTexture.replaceVariables(this.base, context, this.textureVariableMap);
            String[] s = model.split("#", 2);
            if (s.length == 1) {
                return new ModelLayerLocation(new ResourceLocation(s[0]), "main");
            }
            return new ModelLayerLocation(new ResourceLocation(s[0]), s[1]);
        }
    }
}

