/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractBooleanTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;

public class AbilityWheelHoveredVariable
extends AbstractBooleanTextureVariable {
    public AbilityWheelHoveredVariable(String trueValue, String falseValue) {
        super(trueValue, falseValue);
    }

    @Override
    public boolean getBoolean(DataContext context) {
        return context.has(DataContextType.ABILITY_WHEEL_HOVERED) && context.get(DataContextType.ABILITY_WHEEL_HOVERED) != false;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new AbilityWheelHoveredVariable(AbstractBooleanTextureVariable.parseTrueValue(json), AbstractBooleanTextureVariable.parseFalseValue(json));
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Ability Wheel Hovered");
            AbstractBooleanTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("ability_wheel_hovered");
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns a true/false value depending on whether the texture is currently used in an ability, which is hovered over in an ability wheel.";
        }
    }
}

