/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.energybeam;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.energybeam.EnergyBeamRenderer;
import net.threetag.palladium.client.renderer.LaserRenderer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.PerspectiveValue;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladium.util.context.DataContext;
import org.joml.Vector2f;

public class LaserBeamRenderer
extends EnergyBeamRenderer {
    private final LaserRenderer laserRenderer;
    private final PerspectiveValue<Boolean> visibility;

    public LaserBeamRenderer(LaserRenderer laserRenderer, PerspectiveValue<Boolean> visibility) {
        this.laserRenderer = laserRenderer;
        this.visibility = visibility;
    }

    @Override
    public void render(AbstractClientPlayer player, Vec3 origin, Vec3 target, float lengthMultiplier, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, boolean isFirstPerson, float partialTick) {
        if (this.visibility.getForPlayer((Player)player).booleanValue()) {
            Vector2f size = this.laserRenderer.getSize();
            this.laserRenderer.size(size.mul(SizeUtil.getInstance().getModelWidthScale((Entity)player, partialTick), SizeUtil.getInstance().getModelHeightScale((Entity)player, partialTick), new Vector2f())).length((float)origin.m_82554_(target) * lengthMultiplier).faceAndRender(DataContext.forEntity((Entity)player), poseStack, bufferSource, origin, target, player.f_19797_, partialTick);
            this.laserRenderer.size(size);
        }
    }

    public static class Serializer
    extends EnergyBeamRenderer.Serializer {
        public static final ResourceLocation ID = Palladium.id("laser");

        @Override
        public EnergyBeamRenderer fromJson(JsonObject json) {
            return new LaserBeamRenderer(LaserRenderer.fromJson(json), PerspectiveValue.getFromJson(json, "visibility", JsonElement::getAsBoolean, true));
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Laser");
            LaserRenderer.generateDocumentation(builder, 2, false);
            JsonObject exampleJson = new JsonObject();
            exampleJson.addProperty("first_person", Boolean.valueOf(true));
            exampleJson.addProperty("third_person", Boolean.valueOf(true));
            builder.addProperty("visibility", Boolean.class).description("Determines if its visible.").fallback(true).exampleJson((JsonElement)exampleJson);
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }
    }
}

