/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.event.PalladiumClientEvents;

@OnlyIn(value=Dist.CLIENT)
public class PalladiumAnimationRegistry
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final Map<ResourceLocation, PalladiumAnimation> animations = new LinkedHashMap<ResourceLocation, PalladiumAnimation>();
    private final List<PalladiumAnimation> animationsSorted = new LinkedList<PalladiumAnimation>();
    public static boolean SKIP_ANIMATIONS = false;
    public static final PalladiumAnimationRegistry INSTANCE = new PalladiumAnimationRegistry();

    public PalladiumAnimationRegistry() {
        super(GSON, "palladium/animations");
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.animations.clear();
        this.animationsSorted.clear();
        ((PalladiumClientEvents.RegisterAnimations)PalladiumClientEvents.REGISTER_ANIMATIONS.invoker()).register(this::registerAnimation);
        this.animationsSorted.addAll(this.animations.values());
        this.animationsSorted.sort(Comparator.comparingInt(PalladiumAnimation::getPriority));
    }

    public void registerAnimation(ResourceLocation id, PalladiumAnimation animation) {
        this.animations.put(id, animation);
    }

    public static void resetPoses(Iterable<ModelPart> headParts, Iterable<ModelPart> bodyParts) {
        for (ModelPart bodyPart : headParts) {
            bodyPart.m_233569_();
        }
        for (ModelPart bodyPart : bodyParts) {
            bodyPart.m_233569_();
        }
    }

    public static void forEach(AbstractClientPlayer player, HumanoidModel<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks, BiConsumer<PalladiumAnimation.PlayerModelPart, PalladiumAnimation.PartAnimationData> consumer) {
        HashMap gathered = new HashMap();
        for (PalladiumAnimation animation : PalladiumAnimationRegistry.INSTANCE.animationsSorted) {
            PalladiumAnimation.Builder builder = new PalladiumAnimation.Builder();
            animation.animate(builder, player, model, firstPersonContext, partialTicks);
            for (Map.Entry<PalladiumAnimation.PlayerModelPart, PalladiumAnimation.PartAnimationData> entry : builder.getAnimationData().entrySet()) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void forEach(AbstractClientPlayer player, HumanoidModel<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks, BiConsumer<PalladiumAnimation.PlayerModelPart, PalladiumAnimation.PartAnimationData> consumer, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        HashMap gathered = new HashMap();
        for (PalladiumAnimation animation : PalladiumAnimationRegistry.INSTANCE.animationsSorted) {
            PalladiumAnimation.Builder builder = new PalladiumAnimation.Builder(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            animation.animate(builder, player, model, firstPersonContext, partialTicks);
            for (Map.Entry<PalladiumAnimation.PlayerModelPart, PalladiumAnimation.PartAnimationData> entry : builder.getAnimationData().entrySet()) {
                consumer.accept(entry.getKey(), entry.getValue());
            }
        }
    }

    public static void applyAnimations(HumanoidModel<?> model, LivingEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof AbstractClientPlayer) {
            AbstractClientPlayer player = (AbstractClientPlayer)entity;
            PalladiumAnimationRegistry.forEach(player, model, PalladiumAnimation.FirstPersonContext.NONE, Minecraft.m_91087_().m_91296_(), (part, data) -> part.applyToModelPart(model, (PalladiumAnimation.PartAnimationData)data), limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static void applyFirstPersonAnimations(PoseStack poseStack, AbstractClientPlayer player, HumanoidModel<?> model, boolean rightArm) {
        PalladiumAnimation.PoseStackResult result = new PalladiumAnimation.PoseStackResult();
        PalladiumAnimationRegistry.forEach(player, model, rightArm ? PalladiumAnimation.FirstPersonContext.RIGHT_ARM : PalladiumAnimation.FirstPersonContext.LEFT_ARM, Minecraft.m_91087_().m_91296_(), (part, data) -> {
            if (rightArm && part == PalladiumAnimation.PlayerModelPart.RIGHT_ARM) {
                data.apply(result);
            }
            if (!rightArm && part == PalladiumAnimation.PlayerModelPart.LEFT_ARM) {
                data.apply(result);
            }
        });
        result.apply(poseStack);
    }

    public static PalladiumAnimation.PoseStackResult setupRotations(PlayerRenderer playerRenderer, AbstractClientPlayer player, PoseStack poseStack, float partialTicks) {
        PalladiumAnimation.PoseStackResult result = new PalladiumAnimation.PoseStackResult();
        PalladiumAnimationRegistry.forEach(player, (HumanoidModel)playerRenderer.m_7200_(), PalladiumAnimation.FirstPersonContext.NONE, partialTicks, (part, data) -> {
            if (part == PalladiumAnimation.PlayerModelPart.BODY) {
                data.apply(result);
            }
        });
        result.apply(poseStack);
        return result;
    }
}

