/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.particleemitter;

import com.google.gson.JsonObject;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.util.PerspectiveValue;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class ParticleEmitter {
    @Nullable
    private final BodyPart anchor;
    private final float amount;
    private final PerspectiveValue<Vector3f> offset;
    private final PerspectiveValue<Vector3f> offsetRandom;
    private final PerspectiveValue<Vector3f> motion;
    private final PerspectiveValue<Vector3f> motionRandom;
    private final boolean visibleInFirstPerson;

    public ParticleEmitter(@Nullable BodyPart anchor, float amount, PerspectiveValue<Vector3f> offset, PerspectiveValue<Vector3f> offsetRandom, PerspectiveValue<Vector3f> motion, PerspectiveValue<Vector3f> motionRandom, boolean visibleInFirstPerson) {
        this.anchor = anchor;
        this.amount = amount;
        this.offset = offset;
        this.offsetRandom = offsetRandom;
        this.motion = motion;
        this.motionRandom = motionRandom;
        this.visibleInFirstPerson = visibleInFirstPerson;
    }

    public static ParticleEmitter fromJson(JsonObject json) {
        BodyPart bodyPart = BodyPart.byName(GsonHelper.m_13851_((JsonObject)json, (String)"body_part", (String)""));
        float amount = GsonUtil.getAsFloatMin(json, "amount", 0.0f, 1.0f);
        PerspectiveValue<Vector3f> offset = PerspectiveValue.getFromJson(json, "offset", j -> GsonUtil.convertToVector3f(j, "offset").div(16.0f, -16.0f, 16.0f), new Vector3f());
        PerspectiveValue<Vector3f> offsetRandom = PerspectiveValue.getFromJson(json, "offset_random", j -> GsonUtil.convertToVector3f(j, "offset_random").div(16.0f, -16.0f, 16.0f), new Vector3f());
        PerspectiveValue<Vector3f> motion = PerspectiveValue.getFromJson(json, "motion", j -> GsonUtil.convertToVector3f(j, "motion").div(16.0f, -16.0f, 16.0f), new Vector3f());
        PerspectiveValue<Vector3f> motionRandom = PerspectiveValue.getFromJson(json, "motion_random", j -> GsonUtil.convertToVector3f(j, "motion_random").div(16.0f, -16.0f, 16.0f), new Vector3f());
        boolean visibleInFirstPerson = GsonHelper.m_13855_((JsonObject)json, (String)"visible_in_first_person", (boolean)true);
        return new ParticleEmitter(bodyPart, amount, offset, offsetRandom, motion, motionRandom, visibleInFirstPerson);
    }

    public Vec3 getCenter(AbstractClientPlayer player, float partialTick) {
        if (this.anchor != null) {
            return BodyPart.getInWorldPosition(this.anchor, this.offset.get(), player, partialTick);
        }
        Vector3f offset = this.offset.get();
        return player.m_20318_(partialTick).m_82520_(0.0, (double)player.m_20206_() / 2.0, 0.0).m_82520_((double)offset.x, (double)offset.y, (double)offset.z);
    }

    public void spawnParticles(Level level, AbstractClientPlayer player, ParticleOptions particleOptions, float partialTick) {
        if (!this.visibleInFirstPerson && player == Minecraft.m_91087_().f_91074_ && Minecraft.m_91087_().f_91066_.m_92176_() == CameraType.FIRST_PERSON) {
            return;
        }
        RandomSource random = RandomSource.m_216327_();
        if (this.amount < 1.0f) {
            if (Math.random() < (double)this.amount) {
                this.spawnParticleOnPlayer(level, player, particleOptions, random, partialTick);
            }
        } else {
            int i = 0;
            while ((float)i < this.amount) {
                this.spawnParticleOnPlayer(level, player, particleOptions, random, partialTick);
                ++i;
            }
        }
    }

    public void spawnAtPosition(Level level, Vec3 position, ParticleOptions particleOptions) {
        RandomSource random = RandomSource.m_216327_();
        if (this.amount < 1.0f) {
            if (Math.random() < (double)this.amount) {
                this.spawnParticleOnPosition(level, position, particleOptions, random);
            }
        } else {
            int i = 0;
            while ((float)i < this.amount) {
                this.spawnParticleOnPosition(level, position, particleOptions, random);
                ++i;
            }
        }
    }

    private void spawnParticleOnPlayer(Level level, AbstractClientPlayer player, ParticleOptions particleOptions, RandomSource random, float partialTick) {
        Vec3 pos;
        CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_();
        Vector3f offset = ParticleEmitter.randomizeVector(random, this.offset.get(cameraType), this.offsetRandom.get(cameraType));
        Vector3f motion = ParticleEmitter.randomizeVector(random, this.motion.get(cameraType), this.motionRandom.get(cameraType));
        Vec3 vec3 = pos = this.anchor != null ? BodyPart.getInWorldPosition(this.anchor, offset, player, partialTick) : player.m_20318_(partialTick).m_82520_(0.0, (double)player.m_20206_() / 2.0, 0.0).m_82520_((double)offset.x, (double)offset.y, (double)offset.z);
        if (this.anchor != null) {
            Vector3f combined = new Vector3f((Vector3fc)offset).add((Vector3fc)motion);
            Vec3 transformed = BodyPart.getInWorldPosition(this.anchor, combined, player, partialTick);
            Vec3 motionRotated = transformed.m_82546_(pos);
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, motionRotated.f_82479_, motionRotated.f_82480_, motionRotated.f_82481_);
        } else {
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)motion.x, (double)motion.y, (double)motion.z);
        }
    }

    private void spawnParticleOnPosition(Level level, Vec3 position, ParticleOptions particleOptions, RandomSource random) {
        CameraType cameraType = Minecraft.m_91087_().f_91066_.m_92176_();
        Vector3f offset = ParticleEmitter.randomizeVector(random, this.offset.get(cameraType), this.offsetRandom.get(cameraType));
        Vector3f motion = ParticleEmitter.randomizeVector(random, this.motion.get(cameraType), this.motionRandom.get(cameraType));
        Vec3 pos = position.m_82520_((double)offset.x, (double)(-offset.y), (double)offset.z);
        level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, (double)motion.x, (double)(-motion.y), (double)motion.z);
    }

    private static Vector3f randomizeVector(RandomSource random, Vector3f center, Vector3f randomOffset) {
        return new Vector3f((Vector3fc)center).add((random.m_188501_() - 0.5f) * 2.0f * randomOffset.x, (random.m_188501_() - 0.5f) * 2.0f * randomOffset.y, (random.m_188501_() - 0.5f) * 2.0f * randomOffset.z);
    }
}

