/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.netty.util.collection.IntObjectHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.PalladiumConfig;
import net.threetag.palladium.client.PalladiumKeyMappings;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityColor;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladiumcore.event.ClientTickEvents;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;

public class AbilityBarRenderer
implements OverlayRegistry.IngameOverlay {
    public static final ResourceLocation TEXTURE = new ResourceLocation("palladium", "textures/gui/ability_bar.png");
    public static List<AbilityList> ABILITY_LISTS = new ArrayList<AbilityList>();
    public static int SELECTED = 0;

    public AbilityBarRenderer() {
        ClientTickEvents.CLIENT_POST.register(instance -> AbilityBarRenderer.updateCurrentLists());
    }

    public static AbilityList getSelectedList() {
        if (ABILITY_LISTS.isEmpty()) {
            return null;
        }
        if (SELECTED >= ABILITY_LISTS.size() || SELECTED < 0) {
            SELECTED = 0;
        }
        return ABILITY_LISTS.get(SELECTED);
    }

    public void render(Minecraft mc, Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        boolean simple;
        if (ABILITY_LISTS.isEmpty()) {
            return;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        Position position = (Position)((Object)PalladiumConfig.Client.ABILITY_BAR_POSITION.get());
        AbilityList list = AbilityBarRenderer.getSelectedList();
        if (position == Position.HIDDEN || list == null) {
            return;
        }
        if (position.top && mc.f_91066_.f_92063_) {
            return;
        }
        if (!position.top && mc.f_91080_ instanceof ChatScreen) {
            position = position.left ? Position.TOP_LEFT : Position.TOP_RIGHT;
        }
        boolean bl = simple = list.simple && ABILITY_LISTS.size() <= 1;
        if (mc.f_91074_ != null) {
            ResourceLocation texture = list.texture != null ? list.texture : TEXTURE;
            int indicatorWidth = 52;
            int indicatorHeight = 28;
            if (!simple) {
                poseStack.m_85836_();
                AbilityBarRenderer.translateIndicatorBackground(poseStack, mc.m_91268_(), position, indicatorWidth, indicatorHeight);
                AbilityBarRenderer.renderIndicator(list, mc, guiGraphics, poseStack, position, texture, ABILITY_LISTS.size() > 1);
                poseStack.m_85849_();
            }
            if (!list.energyBars.isEmpty()) {
                poseStack.m_85836_();
                AbilityBarRenderer.translateEnergyBars(poseStack, mc.m_91268_(), position, indicatorHeight, 24, list.energyBars.size());
                AbilityBarRenderer.renderEnergyBars(guiGraphics, list, texture);
                poseStack.m_85849_();
            }
            poseStack.m_85836_();
            AbilityBarRenderer.translateAbilitiesBackground(poseStack, mc.m_91268_(), position, indicatorHeight, 24, 112, simple);
            AbilityBarRenderer.renderAbilitiesBackground(mc, guiGraphics, poseStack, position, list, texture, simple);
            AbilityBarRenderer.renderAbilitiesOverlay(mc, guiGraphics, poseStack, position, list, texture, simple);
            poseStack.m_85849_();
        }
    }

    private static void translateIndicatorBackground(PoseStack poseStack, Window window, Position position, int width, int height) {
        if (!position.top) {
            poseStack.m_252880_(0.0f, (float)(window.m_85446_() - height), 0.0f);
        }
        if (!position.left) {
            poseStack.m_252880_((float)(window.m_85445_() - width), 0.0f, 0.0f);
        }
    }

    private static void renderIndicator(AbilityList list, Minecraft minecraft, GuiGraphics guiGraphics, PoseStack poseStack, Position position, ResourceLocation texture, boolean showKey) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(texture, 0, 0, position.left ? 52 : 0, position.top ? 28 : 0, 52, 28);
        list.power.getIcon().draw(minecraft, guiGraphics, DataContext.forPower((LivingEntity)minecraft.f_91074_, list.getPowerHolder()), showKey ? (position.left ? 30 : 6) : (position.left ? 17 : 19), position.top ? 5 : 7);
        if (showKey) {
            FormattedText properties = minecraft.f_91062_.m_92854_((FormattedText)PalladiumKeyMappings.SWITCH_ABILITY_LIST.m_90863_(), 10);
            int length = minecraft.f_91062_.m_92852_(properties) + 10;
            guiGraphics.m_280614_(minecraft.f_91062_, (Component)Component.m_237113_((String)properties.getString()), (int)((float)(position.left ? 15 : 37) - (float)length / 2.0f + 10.0f), position.top ? 10 : 12, -1, false);
            guiGraphics.m_280218_(texture, (position.left ? 15 : 37) - length / 2, position.top ? 9 : 11, 78, minecraft.f_91074_.m_6047_() ? 64 : 56, 8, 8);
        }
    }

    private static void translateAbilitiesBackground(PoseStack poseStack, Window window, Position position, int indicatorHeight, int abilitiesWidth, int abilitiesHeight, boolean simple) {
        if (!simple) {
            if (position.top) {
                poseStack.m_252880_(!position.left ? (float)(window.m_85445_() - abilitiesWidth) : 0.0f, (float)(indicatorHeight - 1), 0.0f);
            } else {
                poseStack.m_252880_(!position.left ? (float)(window.m_85445_() - abilitiesWidth) : 0.0f, (float)(window.m_85446_() - indicatorHeight - abilitiesHeight + 1), 0.0f);
            }
        } else if (position.top) {
            poseStack.m_252880_(!position.left ? (float)(window.m_85445_() - abilitiesWidth) : 0.0f, 0.0f, 0.0f);
        } else {
            poseStack.m_252880_(!position.left ? (float)(window.m_85445_() - abilitiesWidth) : 0.0f, (float)(window.m_85446_() - 24), 0.0f);
        }
    }

    private static void renderAbilitiesBackground(Minecraft minecraft, GuiGraphics guiGraphics, PoseStack poseStack, Position position, AbilityList list, ResourceLocation texture, boolean simple) {
        boolean showName = minecraft.f_91080_ instanceof ChatScreen;
        for (int i = 0; !(i >= 5 || simple && i > 0); ++i) {
            Lighting.m_84931_();
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280218_(texture, 3, i * 22 + 3, 60, 56, 18, 18);
            if (list == null) continue;
            AbilityInstance entry = list.getDisplayedAbilities()[i];
            if (entry != null) {
                if (entry.isEnabled() && entry.activationTimer != 0 && entry.maxActivationTimer != 0) {
                    int height = (int)((float)entry.activationTimer / (float)entry.maxActivationTimer * 18.0f);
                    guiGraphics.m_280218_(texture, 3, i * 22 + 3, 24, 56, 18, 18);
                    guiGraphics.m_280218_(texture, 3, i * 22 + 3 + (18 - height), 42, 74 - height, 18, height);
                } else {
                    guiGraphics.m_280218_(texture, 3, i * 22 + 3, entry.isEnabled() ? 42 : 24, entry.isUnlocked() ? 56 : 74, 18, 18);
                }
                if (entry.cooldown > 0) {
                    int width = (int)((float)entry.cooldown / (float)entry.maxCooldown * 18.0f);
                    guiGraphics.m_280218_(texture, 3, i * 22 + 3, 60, 74, width, 18);
                }
                if (!entry.isUnlocked()) {
                    guiGraphics.m_280218_(texture, 3, i * 22 + 3, 42, 74, 18, 18);
                } else {
                    entry.getProperty(Ability.ICON).draw(minecraft, guiGraphics, DataContext.forAbility((LivingEntity)minecraft.f_91074_, entry), 4, 4 + i * 22);
                }
                if (!showName) continue;
                Tesselator tes = Tesselator.m_85913_();
                BufferBuilder bb = tes.m_85915_();
                Component name = entry.getConfiguration().getDisplayName();
                int width = minecraft.f_91062_.m_92852_((FormattedText)name);
                AbilityBarRenderer.renderBlackBox(bb, tes, poseStack, position.left ? 24 : -width - 10, i * 22 + 5, 10 + width, 14, 0.5f);
                guiGraphics.m_280614_(minecraft.f_91062_, name, position.left ? 29 : -width - 5, i * 22 + 8, -1, false);
                continue;
            }
            guiGraphics.m_280218_(texture, 3, i * 22 + 3, 60, 56, 18, 18);
        }
    }

    private static void renderAbilitiesOverlay(Minecraft minecraft, GuiGraphics guiGraphics, PoseStack poseStack, Position position, AbilityList list, ResourceLocation texture, boolean simple) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!simple) {
            guiGraphics.m_280218_(texture, 0, 0, 0, 56, 24, 112);
        } else {
            guiGraphics.m_280218_(texture, 0, 0, 0, 168, 24, 24);
        }
        for (int i = 0; i < 5; ++i) {
            AbilityInstance ability = list.getDisplayedAbilities()[i];
            if (ability == null) continue;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Lighting.m_84931_();
            RenderSystem.enableBlend();
            if (!ability.isUnlocked()) {
                guiGraphics.m_280218_(texture, 3, i * 22 + 3, 42, 74, 18, 18);
            }
            AbilityColor color = ability.getProperty(Ability.COLOR);
            guiGraphics.m_280218_(texture, 0, i * 22, color.getX(), color.getY(), 24, 24);
            if (!ability.getConfiguration().needsKey() || !ability.isUnlocked()) continue;
            AbilityConfiguration.KeyType keyType = ability.getConfiguration().getKeyType();
            poseStack.m_85836_();
            poseStack.m_252880_(0.0f, 0.0f, 200.0f);
            if (keyType == AbilityConfiguration.KeyType.KEY_BIND) {
                Component key = PalladiumKeyMappings.ABILITY_KEYS[i].m_90863_();
                guiGraphics.m_280614_(minecraft.f_91062_, key, 22 - minecraft.f_91062_.m_92852_((FormattedText)key), 5 + i * 22 + 7, 0xFFFFFF, false);
            } else if (keyType == AbilityConfiguration.KeyType.LEFT_CLICK) {
                guiGraphics.m_280218_(texture, 16, 5 + i * 22 + 8, 24, 92, 5, 7);
            } else if (keyType == AbilityConfiguration.KeyType.RIGHT_CLICK) {
                guiGraphics.m_280218_(texture, 16, 5 + i * 22 + 8, 29, 92, 5, 7);
            } else if (keyType == AbilityConfiguration.KeyType.SPACE_BAR) {
                guiGraphics.m_280218_(texture, 11, 5 + i * 22 + 10, 34, 92, 10, 5);
            } else if (keyType == AbilityConfiguration.KeyType.SCROLL_UP) {
                guiGraphics.m_280218_(texture, 16, 5 + i * 22 + 4, 24, 99, 5, 11);
            } else if (keyType == AbilityConfiguration.KeyType.SCROLL_DOWN) {
                guiGraphics.m_280218_(texture, 16, 5 + i * 22 + 4, 29, 99, 5, 11);
            } else if (keyType == AbilityConfiguration.KeyType.SCROLL_EITHER) {
                guiGraphics.m_280218_(texture, 16, 5 + i * 22 + 2, 34, 99, 5, 13);
            }
            poseStack.m_85849_();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void translateEnergyBars(PoseStack poseStack, Window window, Position position, int indicatorHeight, int abilitiesWidth, int energyBarAmount) {
        int width = energyBarAmount * 9 + 1;
        int height = 104;
        if (position.top) {
            poseStack.m_252880_(!position.left ? (float)(window.m_85445_() - abilitiesWidth - width + 1) : (float)(abilitiesWidth - 1), (float)(indicatorHeight - 1), 0.0f);
        } else {
            poseStack.m_252880_(!position.left ? (float)(window.m_85445_() - abilitiesWidth - width + 1) : (float)(abilitiesWidth - 1), (float)(window.m_85446_() - indicatorHeight - height + 1), 0.0f);
        }
    }

    public static void renderEnergyBars(GuiGraphics guiGraphics, AbilityList list, ResourceLocation texture) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(texture, 0, 0, 152, 0, 1, 104);
        int x = 1;
        for (EnergyBar energyBar : list.energyBars) {
            guiGraphics.m_280218_(texture, x, 0, 153, 0, 9, 104);
            int height = (int)((float)energyBar.get() / (float)energyBar.getMax() * 98.0f);
            Color color = energyBar.getConfiguration().getColor();
            RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
            guiGraphics.m_280218_(texture, x + 2, 101 - height, 162, 98 - height, 4, height);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            x += 9;
        }
    }

    public static void renderBlackBox(BufferBuilder bb, Tesselator tesselator, PoseStack matrixStack, int x, int y, int width, int height, float opacity) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        bb.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        bb.m_252986_(matrixStack.m_85850_().m_252922_(), (float)(x + width), (float)y, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, opacity).m_5752_();
        bb.m_252986_(matrixStack.m_85850_().m_252922_(), (float)x, (float)y, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, opacity).m_5752_();
        bb.m_252986_(matrixStack.m_85850_().m_252922_(), (float)x, (float)(y + height), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, opacity).m_5752_();
        bb.m_252986_(matrixStack.m_85850_().m_252922_(), (float)(x + width), (float)(y + height), 0.0f).m_85950_(0.0f, 0.0f, 0.0f, opacity).m_5752_();
        tesselator.m_85914_();
        RenderSystem.disableBlend();
    }

    public static void updateCurrentLists() {
        if (Minecraft.m_91087_() != null && Minecraft.m_91087_().f_91074_ != null && SELECTED >= (ABILITY_LISTS = AbilityBarRenderer.getAbilityLists()).size()) {
            SELECTED = ABILITY_LISTS.size() - 1;
        }
    }

    public static void scroll(boolean up) {
        SELECTED = up ? ++SELECTED : --SELECTED;
        if (SELECTED >= ABILITY_LISTS.size()) {
            SELECTED = 0;
        } else if (SELECTED < 0) {
            SELECTED = ABILITY_LISTS.size() - 1;
        }
    }

    public static List<AbilityList> getAbilityLists() {
        ArrayList<AbilityList> lists = new ArrayList<AbilityList>();
        IPowerHandler handler = PowerManager.getPowerHandler((LivingEntity)Minecraft.m_91087_().f_91074_).orElse(null);
        if (handler == null) {
            return lists;
        }
        for (IPowerHolder holder : handler.getPowerHolders().values()) {
            ArrayList<AbilityList> containerList = new ArrayList<AbilityList>();
            ArrayList<AbilityList> remainingLists = new ArrayList<AbilityList>();
            ArrayList<AbilityInstance> remaining = new ArrayList<AbilityInstance>();
            for (AbilityInstance abilityInstance : holder.getAbilities().values()) {
                int i = abilityInstance.getProperty(Ability.LIST_INDEX);
                if (!abilityInstance.getConfiguration().needsKey() || abilityInstance.getProperty(Ability.HIDDEN_IN_BAR).booleanValue()) continue;
                if (i >= 0) {
                    int listIndex = Math.floorDiv(i, 5);
                    int index = i % 5;
                    while (containerList.size() - 1 < listIndex) {
                        containerList.add(new AbilityList(holder));
                    }
                    AbilityList abilityList = (AbilityList)containerList.get(listIndex);
                    abilityList.addAbility(index, abilityInstance);
                    continue;
                }
                remaining.add(abilityInstance);
            }
            for (int i = 0; i < remaining.size(); ++i) {
                AbilityInstance abilityInstance;
                abilityInstance = (AbilityInstance)remaining.get(i);
                int listIndex = Math.floorDiv(i, 5);
                int index = i % 5;
                while (remainingLists.size() - 1 < listIndex) {
                    remainingLists.add(new AbilityList(holder));
                }
                AbilityList abilityList = (AbilityList)remainingLists.get(listIndex);
                abilityList.addAbility(index, abilityInstance);
            }
            for (AbilityList list : containerList) {
                if (list.isEmpty() || list.isFullyLocked()) continue;
                lists.add(list);
            }
            for (AbilityList list : remainingLists) {
                if (list.isEmpty() || list.isFullyLocked()) continue;
                lists.add(list);
            }
        }
        if (lists.size() <= 1) {
            lists.forEach(AbilityList::simplify);
        }
        return lists;
    }

    public static class AbilityList {
        private static final int SIZE = 5;
        private final IPowerHolder powerHolder;
        private final Power power;
        private final IntObjectHashMap<List<AbilityInstance>> abilities = new IntObjectHashMap();
        private final ResourceLocation texture;
        public boolean simple = false;
        private final Collection<EnergyBar> energyBars;

        public AbilityList(IPowerHolder powerHolder) {
            this.powerHolder = powerHolder;
            this.power = powerHolder.getPower();
            TextureReference powerTex = this.power.getAbilityBarTexture();
            this.texture = powerTex != null ? powerTex.getTexture(DataContext.forPower((LivingEntity)Minecraft.m_91087_().f_91074_, this.powerHolder)) : null;
            this.energyBars = powerHolder.getEnergyBars().values();
        }

        public IPowerHolder getPowerHolder() {
            return this.powerHolder;
        }

        public Power getPower() {
            return this.power;
        }

        public Collection<EnergyBar> getEnergyBars() {
            return this.energyBars;
        }

        public AbilityList addAbility(int index, AbilityInstance ability) {
            ((List)this.abilities.computeIfAbsent((Object)index, integer -> new ArrayList())).add(ability);
            return this;
        }

        public boolean addAbility(AbilityInstance ability) {
            for (int i = 0; i < 5; ++i) {
                if (this.abilities.get(i) != null && !((List)this.abilities.get(i)).isEmpty()) continue;
                ((List)this.abilities.computeIfAbsent((Object)i, integer -> new ArrayList())).add(ability);
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            for (int i = 0; i < 5; ++i) {
                if (this.abilities.get(i) == null || ((List)this.abilities.get(i)).isEmpty()) continue;
                return false;
            }
            return true;
        }

        public boolean isFullyLocked() {
            for (AbilityInstance entry : this.getDisplayedAbilities()) {
                if (entry == null || !entry.isUnlocked()) continue;
                return false;
            }
            return true;
        }

        public AbilityInstance[] getDisplayedAbilities() {
            AbilityInstance[] entries = new AbilityInstance[5];
            for (int i = 0; i < 5; ++i) {
                if (this.abilities.get(i) == null) continue;
                for (AbilityInstance entry : (List)this.abilities.get(i)) {
                    AbilityInstance current = entries[i];
                    if (current == null) {
                        entries[i] = entry;
                        continue;
                    }
                    if (current.isUnlocked() || !entry.isUnlocked()) continue;
                    entries[i] = entry;
                }
            }
            return entries;
        }

        public void simplify() {
            if (!this.power.allowBarShrinking() || !this.energyBars.isEmpty()) {
                return;
            }
            int abilities = 0;
            AbilityInstance entry = null;
            for (AbilityInstance ability : this.getDisplayedAbilities()) {
                if (ability == null || !ability.isUnlocked()) continue;
                ++abilities;
                entry = ability;
            }
            boolean bl = this.simple = abilities == 1;
            if (this.simple) {
                this.abilities.clear();
                this.addAbility(0, entry);
            }
        }
    }

    public static enum Position {
        TOP_LEFT(true, true),
        TOP_RIGHT(false, true),
        BOTTOM_LEFT(true, false),
        BOTTOM_RIGHT(false, false),
        HIDDEN(false, false);

        private final boolean left;
        private final boolean top;

        private Position(boolean left, boolean top) {
            this.left = left;
            this.top = top;
        }
    }
}

