/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.screen.AbilityBarRenderer;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;
import net.threetag.palladiumcore.registry.client.OverlayRegistry;
import org.joml.Matrix4f;

public class AbilityWheelRenderer
implements OverlayRegistry.IngameOverlay {
    private static final float SPACING_BETWEEN = 5.0f;
    public static Wheel CURRENT_WHEEL = null;

    public void render(Minecraft minecraft, Gui gui, GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        if (CURRENT_WHEEL != null) {
            int abilityAmount = AbilityWheelRenderer.CURRENT_WHEEL.abilities.size();
            float outerRadius = 100.0f;
            float innerRadius = 50.0f;
            float centerRadius = (outerRadius + innerRadius) / 2.0f;
            int steps = 90 / abilityAmount;
            TextureReference texture = CURRENT_WHEEL.getTexture();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)minecraft.m_91268_().m_85445_() / 2.0f, (float)minecraft.m_91268_().m_85446_() / 2.0f, 0.0f);
            if (texture != null) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(0.78125f, 0.78125f, 1.0f);
                guiGraphics.m_280163_(Objects.requireNonNull(texture.getTexture(DataContext.forEntity((Entity)minecraft.f_91074_).with(DataContextType.ABILITY_WHEEL_SELECTION, AbilityWheelRenderer.CURRENT_WHEEL.selected + 1))), -128, -128, 0.0f, 0.0f, 256, 256, 256, 256);
                guiGraphics.m_280168_().m_85849_();
            }
            for (int i = 0; i < abilityAmount; ++i) {
                boolean selected;
                AbilityInstance ability = AbilityWheelRenderer.CURRENT_WHEEL.abilities.get(i);
                double startAngle = (double)(AbilityWheelRenderer.CURRENT_WHEEL.degreesPerSegment * (float)i) + 2.5 - 90.0 - (double)AbilityWheelRenderer.CURRENT_WHEEL.degreesPerSegment / 2.0;
                double endAngle = (double)(AbilityWheelRenderer.CURRENT_WHEEL.degreesPerSegment * (float)(i + 1)) - 2.5 - 90.0 - (double)AbilityWheelRenderer.CURRENT_WHEEL.degreesPerSegment / 2.0;
                boolean bl = selected = i == AbilityWheelRenderer.CURRENT_WHEEL.selected;
                if (texture == null) {
                    float outerRadius_ = selected ? outerRadius + 15.0f : outerRadius;
                    for (int j = 0; j < steps; ++j) {
                        float g;
                        float r;
                        double angle1 = Math.toRadians(startAngle + (endAngle - startAngle) * (double)j / (double)steps);
                        double angle2 = Math.toRadians(startAngle + (endAngle - startAngle) * (double)(j + 1) / (double)steps);
                        Vec2 outer1 = new Vec2((float)Math.cos(angle1) * outerRadius_, (float)Math.sin(angle1) * outerRadius_);
                        Vec2 outer2 = new Vec2((float)Math.cos(angle2) * outerRadius_, (float)Math.sin(angle2) * outerRadius_);
                        Vec2 inner1 = new Vec2((float)Math.cos(angle1) * innerRadius, (float)Math.sin(angle1) * innerRadius);
                        Vec2 inner2 = new Vec2((float)Math.cos(angle2) * innerRadius, (float)Math.sin(angle2) * innerRadius);
                        float f = selected ? (ability.isUnlocked() ? 1.0f : 0.5f) : (r = 0.0f);
                        float f2 = selected ? (ability.isUnlocked() ? 1.0f : 0.0f) : (g = 0.0f);
                        float b = selected ? (ability.isUnlocked() ? 1.0f : 0.0f) : 0.0f;
                        AbilityWheelRenderer.renderQuad(minecraft, guiGraphics, inner1, inner2, outer2, outer1, r, g, b);
                        guiGraphics.m_280509_(-1000, -1000, -999, -999, -16777216);
                    }
                }
                double centerAngle = Math.toRadians((endAngle + startAngle) / 2.0);
                Vec2 center = new Vec2((float)Math.cos(centerAngle) * centerRadius, (float)Math.sin(centerAngle) * centerRadius);
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_252880_((float)((int)center.f_82470_), (float)((int)center.f_82471_), 0.0f);
                float scale = selected && texture == null ? 1.5f : 1.0f;
                guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
                if (!ability.isUnlocked()) {
                    guiGraphics.m_280218_(AbilityBarRenderer.TEXTURE, -8, -8, 42, 74, 18, 18);
                } else {
                    ability.getProperty(Ability.ICON).draw(minecraft, guiGraphics, DataContext.forAbility((LivingEntity)minecraft.f_91074_, ability).with(DataContextType.ABILITY_WHEEL_HOVERED, selected), -8, -8);
                }
                guiGraphics.m_280168_().m_85849_();
                if (!selected || CURRENT_WHEEL.disablesCenterIcon()) continue;
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85841_(2.0f, 2.0f, 1.0f);
                if (!ability.isUnlocked()) {
                    guiGraphics.m_280218_(AbilityBarRenderer.TEXTURE, -8, -8, 42, 74, 18, 18);
                } else {
                    ability.getProperty(Ability.ICON).draw(minecraft, guiGraphics, DataContext.forAbility((LivingEntity)minecraft.f_91074_, ability).with(DataContextType.ABILITY_WHEEL_DISPLAYED, true), -8, -8);
                }
                guiGraphics.m_280168_().m_85849_();
                Component text = ability.getConfiguration().getDisplayName();
                int length = minecraft.f_91062_.m_92852_((FormattedText)text);
                guiGraphics.m_280430_(minecraft.f_91062_, ability.getConfiguration().getDisplayName(), -(length / 2), (int)outerRadius + 25, 0xFFFFFF);
            }
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private static void renderQuad(Minecraft minecraft, GuiGraphics guiGraphics, Vec2 v1, Vec2 v2, Vec2 v3, Vec2 v4, float r, float g, float b) {
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        VertexConsumer consumer = minecraft.m_91269_().m_110104_().m_6299_(RenderType.m_285907_());
        float opacity = 0.5f;
        consumer.m_252986_(matrix, v1.f_82470_, v1.f_82471_, 0.0f).m_85950_(r, g, b, opacity).m_5752_();
        consumer.m_252986_(matrix, v2.f_82470_, v2.f_82471_, 0.0f).m_85950_(r, g, b, opacity).m_5752_();
        consumer.m_252986_(matrix, v3.f_82470_, v3.f_82471_, 0.0f).m_85950_(r, g, b, opacity).m_5752_();
        consumer.m_252986_(matrix, v4.f_82470_, v4.f_82471_, 0.0f).m_85950_(r, g, b, opacity).m_5752_();
    }

    public static void setWheel(Wheel wheel) {
        CURRENT_WHEEL = wheel;
    }

    public static final class Wheel {
        private final List<AbilityInstance> abilities;
        private final TextureReference texture;
        private final boolean disableMouseScrolling;
        private final boolean disableCenterIcon;
        private final float degreesPerSegment;
        private int selected = -1;
        private AbilityInstance selectedAbility = null;
        private double posX = 0.0;
        private double posY = 0.0;

        public Wheel(List<AbilityInstance> abilities, TextureReference texture, boolean disableMouseScrolling, boolean disableCenterIcon) {
            this.abilities = abilities;
            this.degreesPerSegment = 360.0f / (float)abilities.size();
            this.texture = texture;
            this.disableMouseScrolling = disableMouseScrolling;
            this.disableCenterIcon = disableCenterIcon;
        }

        public List<AbilityInstance> abilities() {
            return this.abilities;
        }

        public TextureReference getTexture() {
            return this.texture;
        }

        public boolean disablesMouseScrolling() {
            return this.disableMouseScrolling;
        }

        public boolean disablesCenterIcon() {
            return this.disableCenterIcon;
        }

        public AbilityInstance getSelectedAbility() {
            return this.selectedAbility;
        }

        public void setFromMouseInput(double dx, double dy) {
            double adjustedAngle;
            this.posX = Mth.m_14008_((double)(this.posX + dx), (double)-500.0, (double)500.0);
            this.posY = Mth.m_14008_((double)(this.posY + dy), (double)-500.0, (double)500.0);
            double angle = Math.atan2(this.posY, this.posX);
            for (angle = Math.toDegrees(angle); angle >= 360.0; angle -= 360.0) {
            }
            while (angle < 0.0) {
                angle += 360.0;
            }
            for (adjustedAngle = angle + 2.5 - 180.0 - (double)this.degreesPerSegment / 2.0; adjustedAngle >= 360.0; adjustedAngle -= 360.0) {
            }
            while (adjustedAngle < 0.0) {
                adjustedAngle += 360.0;
            }
            this.selected = Mth.m_14045_((int)((int)(adjustedAngle / (double)this.degreesPerSegment)), (int)0, (int)(this.abilities.size() - 1));
            this.selectedAbility = this.abilities.get(this.selected);
        }

        public void scroll(boolean up) {
            this.selected += up ? 1 : -1;
            if (this.selected < 0) {
                this.selected = this.abilities.size() - 1;
            } else if (this.selected >= this.abilities.size()) {
                this.selected = 0;
            }
            this.selectedAbility = this.abilities.get(Mth.m_14045_((int)this.selected, (int)0, (int)(this.abilities.size() - 1)));
        }
    }
}

