/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.components;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import org.jetbrains.annotations.Nullable;

public class TextWithIconButton
extends Button {
    private final Component suffix;
    private final IIcon icon;

    public TextWithIconButton(int i, int j, int k, int l, @Nullable Component prefix, @Nullable Component suffix, IIcon icon, Button.OnPress onPress, Button.CreateNarration narration) {
        super(i, j, k, l, (Component)(prefix == null ? Component.m_237119_() : prefix), onPress, narration);
        this.suffix = suffix == null ? Component.m_237119_() : suffix;
        this.icon = icon;
    }

    protected void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Minecraft minecraft = Minecraft.m_91087_();
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        guiGraphics.m_280027_(f_93617_, this.m_252754_(), this.m_252907_(), this.m_5711_(), this.m_93694_(), 20, 4, 200, 20, 0, this.getTextureY());
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        int i = this.f_93623_ ? 0xFFFFFF : 0xA0A0A0;
        int prefixWidth = minecraft.f_91062_.m_92852_((FormattedText)this.m_6035_());
        int fullTextWidth = prefixWidth + 16 + minecraft.f_91062_.m_92852_((FormattedText)this.suffix);
        int color = i | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24;
        guiGraphics.m_280430_(minecraft.f_91062_, this.m_6035_(), (int)((float)this.m_252754_() + (float)this.f_93618_ / 2.0f - (float)fullTextWidth / 2.0f), (int)((float)this.m_252907_() + (float)(this.m_93694_() - 8) / 2.0f), color);
        guiGraphics.m_280430_(minecraft.f_91062_, this.suffix, (int)((float)this.m_252754_() + (float)this.f_93618_ / 2.0f - (float)fullTextWidth / 2.0f + (float)prefixWidth + 16.0f), (int)((float)this.m_252907_() + ((float)this.f_93619_ - 8.0f) / 2.0f), color);
        this.icon.draw(minecraft, guiGraphics, DataContext.forEntity((Entity)minecraft.f_91074_), this.m_252754_() + this.f_93618_ / 2 - fullTextWidth / 2 + prefixWidth, this.m_252907_() + (this.f_93619_ - 8) / 2 - 4);
    }

    private int getTextureY() {
        int i = 1;
        if (!this.f_93623_) {
            i = 0;
        } else if (this.m_198029_()) {
            i = 2;
        }
        return 46 + i * 20;
    }

    public static Builder textWithIconBuilder(Component prefix, IIcon icon, Button.OnPress onPress) {
        return new Builder(prefix, icon, onPress);
    }

    public static Builder textWithIconBuilder(IIcon icon, Component suffix, Button.OnPress onPress) {
        return new Builder(icon, suffix, onPress);
    }

    public static Builder textWithIconBuilder(Component prefix, IIcon icon, Component suffix, Button.OnPress onPress) {
        return new Builder(prefix, icon, suffix, onPress);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Builder {
        private final Component prefix;
        private final Component suffix;
        private final IIcon icon;
        private final Button.OnPress onPress;
        @Nullable
        private Tooltip tooltip;
        private int x;
        private int y;
        private int width = 150;
        private int height = 20;
        private Button.CreateNarration createNarration;

        public Builder(Component prefix, IIcon icon, Button.OnPress onPress) {
            this.createNarration = f_252438_;
            this.prefix = prefix;
            this.suffix = null;
            this.icon = icon;
            this.onPress = onPress;
        }

        public Builder(IIcon icon, Component suffix, Button.OnPress onPress) {
            this.createNarration = f_252438_;
            this.prefix = null;
            this.suffix = suffix;
            this.icon = icon;
            this.onPress = onPress;
        }

        public Builder(Component prefix, IIcon icon, Component suffix, Button.OnPress onPress) {
            this.createNarration = f_252438_;
            this.prefix = prefix;
            this.suffix = suffix;
            this.icon = icon;
            this.onPress = onPress;
        }

        public Builder pos(int x, int y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Builder width(int width) {
            this.width = width;
            return this;
        }

        public Builder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder bounds(int x, int y, int width, int height) {
            return this.pos(x, y).size(width, height);
        }

        public Builder tooltip(@Nullable Tooltip tooltip) {
            this.tooltip = tooltip;
            return this;
        }

        public Builder createNarration(Button.CreateNarration createNarration) {
            this.createNarration = createNarration;
            return this;
        }

        public Button build() {
            TextWithIconButton button = new TextWithIconButton(this.x, this.y, this.width, this.height, this.prefix, this.suffix, this.icon, this.onPress, this.createNarration);
            button.m_257544_(this.tooltip);
            return button;
        }
    }
}

