/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.screen.power;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.client.screen.power.TreePowerTab;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityDescription;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.context.DataContext;

public class TreeAbilityWidget {
    private static final int HEIGHT = 26;
    private static final int BOX_X = 0;
    private static final int BOX_WIDTH = 200;
    private static final int FRAME_WIDTH = 26;
    private static final int ICON_X = 8;
    private static final int ICON_Y = 5;
    private static final int ICON_WIDTH = 26;
    private static final int TITLE_PADDING_LEFT = 3;
    private static final int TITLE_PADDING_RIGHT = 5;
    private static final int TITLE_X = 32;
    private static final int TITLE_Y = 9;
    private static final int TITLE_MAX_WIDTH = 163;
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private final TreePowerTab tab;
    private final IPowerHolder holder;
    public final AbilityInstance abilityInstance;
    private final FormattedCharSequence title;
    private final int width;
    private final List<FormattedCharSequence> description;
    private final Minecraft minecraft;
    List<TreeAbilityWidget> parents = new LinkedList<TreeAbilityWidget>();
    List<TreeAbilityWidget> children = new LinkedList<TreeAbilityWidget>();
    private int x;
    private int y;
    public double gridX;
    public double gridY;
    public boolean fixedPosition = false;

    public TreeAbilityWidget(TreePowerTab tab, Minecraft mc, IPowerHolder holder, AbilityInstance abilityInstance) {
        this.tab = tab;
        this.holder = holder;
        this.abilityInstance = abilityInstance;
        this.minecraft = mc;
        this.title = Language.m_128107_().m_5536_(mc.f_91062_.m_92854_((FormattedText)abilityInstance.getConfiguration().getDisplayName(), 163));
        int l = 29 + mc.f_91062_.m_92724_(this.title);
        AbilityDescription description = abilityInstance.getProperty(Ability.DESCRIPTION);
        this.description = Language.m_128107_().m_128112_(this.findOptimalLines((Component)ComponentUtils.m_130750_((MutableComponent)(description != null ? description.get(this.abilityInstance.isUnlocked()).m_6881_() : Component.m_237119_()), (Style)Style.f_131099_.m_131140_(ChatFormatting.WHITE)), l));
        for (FormattedCharSequence formattedCharSequence : this.description) {
            l = Math.max(l, this.minecraft.f_91062_.m_92724_(formattedCharSequence));
        }
        this.width = l + 3 + 5;
    }

    public TreeAbilityWidget updatePosition(double x, double y, TreePowerTab tab) {
        this.gridX = x;
        this.gridY = y;
        this.x = (int)(x * 50.0) - 16;
        this.y = (int)(tab.getFreeYPos(x, y) * 50.0) - 13;
        for (TreeAbilityWidget child : this.children) {
            child.updatePosition(this.gridX + 1.0, y, tab);
        }
        return this;
    }

    public TreeAbilityWidget setPosition(double x, double y) {
        this.gridX = x;
        this.gridY = y;
        this.x = (int)(x * 50.0) - 16;
        this.y = (int)(y * 50.0) - 13;
        return this;
    }

    public TreeAbilityWidget setPositionFixed(double x, double y) {
        this.fixedPosition = true;
        return this.setPosition(x, y);
    }

    public TreeAbilityWidget updateRelatives(Collection<TreeAbilityWidget> list) {
        this.parents.clear();
        this.children.clear();
        List<AbilityInstance> parents = Ability.findParentsWithinHolder(this.abilityInstance.getConfiguration(), this.holder);
        List<AbilityInstance> children = Ability.findChildrenWithinHolder(this.abilityInstance.getConfiguration(), this.holder);
        for (TreeAbilityWidget widget : list) {
            if (!parents.isEmpty() && parents.contains(widget.abilityInstance)) {
                this.parents.add(widget);
            }
            if (children.isEmpty() || !children.contains(widget.abilityInstance)) continue;
            this.children.add(widget);
        }
        return this;
    }

    private static float getMaxWidth(StringSplitter manager, List<FormattedText> text) {
        return (float)text.stream().mapToDouble(arg_0 -> ((StringSplitter)manager).m_92384_(arg_0)).max().orElse(0.0);
    }

    private List<FormattedText> findOptimalLines(Component component, int maxWidth) {
        StringSplitter stringSplitter = this.minecraft.f_91062_.m_92865_();
        List list = null;
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list2 = stringSplitter.m_92414_((FormattedText)component, maxWidth - i, Style.f_131099_);
            float g = Math.abs(TreeAbilityWidget.getMaxWidth(stringSplitter, list2) - (float)maxWidth);
            if (g <= 10.0f) {
                return list2;
            }
            if (!(g < f)) continue;
            f = g;
            list = list2;
        }
        return list;
    }

    public void drawDisplayIcon(Minecraft mc, GuiGraphics guiGraphics, int x, int y) {
        if (this.abilityInstance.isUnlocked()) {
            this.abilityInstance.getProperty(Ability.ICON).draw(mc, guiGraphics, DataContext.forAbility((LivingEntity)mc.f_91074_, this.abilityInstance), x, y);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280218_(PowersScreen.WIDGETS, x, y, 90, 83, 16, 16);
        }
    }

    public void drawIcon(Minecraft mc, GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(PowersScreen.WIDGETS, x - 13, y - 13, 0, this.abilityInstance.isUnlocked() ? 78 : 104, 26, 26);
        this.drawDisplayIcon(mc, guiGraphics, x - 8, y - 8);
    }

    public int getWidth() {
        return this.width;
    }

    public void drawHover(GuiGraphics guiGraphics, int x, int y, float fade, int width, int height) {
        AdvancementWidgetType advancementWidgetType3;
        AdvancementWidgetType advancementWidgetType2;
        AdvancementWidgetType advancementWidgetType;
        boolean bl = width + x + this.x + this.width + 26 >= this.tab.getScreen().f_96543_;
        String string = null;
        int i = string == null ? 0 : this.minecraft.f_91062_.m_92895_(string);
        boolean bl2 = 113 - y - this.y - 26 <= 6 + this.description.size() * 9;
        float f = 0.0f;
        int j = Mth.m_14143_((float)(f * (float)this.width));
        if (f >= 1.0f) {
            j = this.width / 2;
            advancementWidgetType = AdvancementWidgetType.OBTAINED;
            advancementWidgetType2 = AdvancementWidgetType.OBTAINED;
            advancementWidgetType3 = AdvancementWidgetType.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            advancementWidgetType = AdvancementWidgetType.UNOBTAINED;
            advancementWidgetType2 = AdvancementWidgetType.UNOBTAINED;
            advancementWidgetType3 = AdvancementWidgetType.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            advancementWidgetType = AdvancementWidgetType.OBTAINED;
            advancementWidgetType2 = AdvancementWidgetType.OBTAINED;
            advancementWidgetType3 = AdvancementWidgetType.UNOBTAINED;
        } else {
            advancementWidgetType = AdvancementWidgetType.OBTAINED;
            advancementWidgetType2 = AdvancementWidgetType.UNOBTAINED;
            advancementWidgetType3 = AdvancementWidgetType.UNOBTAINED;
        }
        int k = this.width - j;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int l = y + this.y;
        int m = bl ? x + this.x - this.width + 26 + 6 : x + this.x;
        int n = 32 + this.description.size() * 9;
        if (!this.description.isEmpty()) {
            if (bl2) {
                guiGraphics.m_280260_(PowersScreen.WIDGETS, m, l + 26 - n, this.width, n, 10, 200, 26, 0, 52);
            } else {
                guiGraphics.m_280260_(PowersScreen.WIDGETS, m, l, this.width, n, 10, 200, 26, 0, 52);
            }
        }
        guiGraphics.m_280218_(PowersScreen.WIDGETS, m, l, 0, advancementWidgetType.m_97325_() * 26, j, 26);
        guiGraphics.m_280218_(PowersScreen.WIDGETS, m + j, l, 200 - k, advancementWidgetType2.m_97325_() * 26, k, 26);
        guiGraphics.m_280218_(PowersScreen.WIDGETS, x + this.x + 3, y + this.y, 0, 78 + advancementWidgetType3.m_97325_() * 26, 26, 26);
        if (bl) {
            guiGraphics.m_280648_(this.minecraft.f_91062_, this.title, m + 5, y + this.y + 9, -1);
            if (string != null) {
                guiGraphics.m_280488_(this.minecraft.f_91062_, string, x + this.x - i, y + this.y + 9, -1);
            }
        } else {
            guiGraphics.m_280648_(this.minecraft.f_91062_, this.title, x + this.x + 32, y + this.y + 9, -1);
            if (string != null) {
                guiGraphics.m_280488_(this.minecraft.f_91062_, string, x + this.x + this.width - i - 5, y + this.y + 9, -1);
            }
        }
        if (bl2) {
            for (int o = 0; o < this.description.size(); ++o) {
                guiGraphics.m_280648_(this.minecraft.f_91062_, this.description.get(o), m + 5, l + 26 - n + 7 + o * 9, -5592406);
            }
        } else {
            for (int o = 0; o < this.description.size(); ++o) {
                guiGraphics.m_280648_(this.minecraft.f_91062_, this.description.get(o), m + 5, y + this.y + 9 + 17 + o * 9, -5592406);
            }
        }
        this.drawDisplayIcon(this.minecraft, guiGraphics, x + this.x + 8, y + this.y + 5);
    }

    public boolean isMouseOver(int x, int y, int mouseX, int mouseY) {
        int i = x + this.x;
        int j = i + 26;
        int k = y + this.y;
        int l = k + 26;
        return mouseX >= i && mouseX <= j && mouseY >= k && mouseY <= l;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }
}

