/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.curios.forge;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.threetag.palladium.addonpack.AddonPackManager;
import net.threetag.palladium.addonpack.PackData;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.compat.curios.forge.CuriosPowerProvider;
import net.threetag.palladium.compat.curios.forge.CuriosUtil;
import net.threetag.palladium.compat.curiostinkets.CuriosTrinketsUtil;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.power.provider.PowerProvider;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.registry.DeferredRegister;
import net.threetag.palladiumcore.registry.RegistrySupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypeMessage;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat {
    public static final DeferredRegister<PowerProvider> FACTORIES = DeferredRegister.create((String)"curios", PowerProvider.REGISTRY);
    public static final RegistrySupplier<PowerProvider> CURIOS = FACTORIES.register("curios", CuriosPowerProvider::new);

    public static void init() {
        CuriosTrinketsUtil.setInstance(new CuriosUtil());
        MinecraftForge.EVENT_BUS.register((Object)CuriosTrinketsUtil.getInstance());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(CuriosCompat::interModQueue);
        FACTORIES.register();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        PackRenderLayerManager.registerProvider((entity, layers) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
                    IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                    IDynamicStackHandler cosmeticStacksHandler = stacksHandler.getCosmeticStacks();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        IAddonItem addonItem;
                        Item patt3801$temp;
                        boolean renderable;
                        ItemStack stack = cosmeticStacksHandler.getStackInSlot(i);
                        boolean cosmetic = true;
                        NonNullList renderStates = stacksHandler.getRenders();
                        boolean bl = renderable = renderStates.size() > i && (Boolean)renderStates.get(i) != false;
                        if (stack.m_41619_() && renderable) {
                            stack = stackHandler.getStackInSlot(i);
                            cosmetic = false;
                        }
                        if (stack.m_41619_() || !((patt3801$temp = stack.m_41720_()) instanceof IAddonItem) || (addonItem = (IAddonItem)patt3801$temp).getRenderLayerContainer() == null) continue;
                        IAddonItem.RenderLayerContainer container = addonItem.getRenderLayerContainer();
                        for (ResourceLocation layerId : container.get("curios:" + id)) {
                            IPackRenderLayer layer = PackRenderLayerManager.getInstance().getLayer(layerId);
                            if (layer == null) continue;
                            layers.accept(DataContext.forItem(entity, stack), layer);
                        }
                    }
                }));
            }
        });
    }

    @Deprecated
    public static void interModQueue(InterModEnqueueEvent e) {
        for (PackData pack : AddonPackManager.getInstance().getPacks()) {
            if (!pack.getCustomData().has("curios")) continue;
            AddonPackLog.warning("Addon Pack " + pack.getId() + " adds Curios slots in pack.mcmeta, this is deprecated! Please use the new system: https://docs.illusivesoulworks.com/curios/datapack-example", new Object[0]);
            JsonObject curios = GsonHelper.m_13930_((JsonObject)pack.getCustomData(), (String)"curios");
            for (Map.Entry entry : curios.entrySet()) {
                String name = (String)entry.getKey();
                InterModComms.sendTo((String)"curios", (String)"register_type", () -> {
                    if (((JsonElement)entry.getValue()).isJsonPrimitive() && ((JsonElement)entry.getValue()).getAsBoolean()) {
                        return new SlotTypeMessage.Builder(name).build();
                    }
                    JsonObject curiosJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    SlotTypeMessage.Builder builder = new SlotTypeMessage.Builder(name);
                    if (GsonHelper.m_13900_((JsonObject)curiosJson, (String)"icon")) {
                        builder.icon(GsonUtil.getAsResourceLocation(curiosJson, "icon"));
                    }
                    if (GsonHelper.m_13900_((JsonObject)curiosJson, (String)"priority")) {
                        builder.priority(GsonHelper.m_13927_((JsonObject)curiosJson, (String)"priority"));
                    }
                    if (GsonHelper.m_13900_((JsonObject)curiosJson, (String)"size")) {
                        builder.size(GsonHelper.m_13927_((JsonObject)curiosJson, (String)"size"));
                    }
                    if (GsonHelper.m_13900_((JsonObject)curiosJson, (String)"hide") && GsonHelper.m_13912_((JsonObject)curiosJson, (String)"hide")) {
                        builder.hide();
                    }
                    if (GsonHelper.m_13900_((JsonObject)curiosJson, (String)"cosmetic") && GsonHelper.m_13912_((JsonObject)curiosJson, (String)"cosmetic")) {
                        builder.cosmetic();
                    }
                    return builder.build();
                });
            }
        }
    }

    public static class Provider
    implements ICapabilityProvider {
        final LazyOptional<ICurio> capability = LazyOptional.of(() -> curio);

        Provider(ICurio curio) {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CuriosCapability.ITEM.orEmpty(cap, this.capability);
        }
    }
}

