/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.ability;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.compat.geckolib.armor.AddonGeoArmorItem;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.StringProperty;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animation.AnimationController;

public class ArmorAnimationAbility
extends Ability {
    public static final PalladiumProperty<ResourceLocation> ITEM = new ResourceLocationProperty("item").configurable("ID of the gecko armor item that must be worn currently.");
    public static final PalladiumProperty<String> CONTROLLER = new StringProperty("controller").configurable("Name of the animation controller the animation is played on. Leave it as 'main' if you didnt specify one.");
    public static final PalladiumProperty<String> ANIMATION_TRIGGER = new StringProperty("animation_trigger").configurable("Name of the animation trigger");

    public ArmorAnimationAbility() {
        this.withProperty(ITEM, new ResourceLocation("test", "example_item"));
        this.withProperty(CONTROLLER, "main");
        this.withProperty(ANIMATION_TRIGGER, "animation_trigger_name");
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public void firstTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        Item item;
        if (enabled && entity.m_9236_().f_46443_ && (item = (Item)BuiltInRegistries.f_257033_.m_7745_(entry.getProperty(ITEM))) instanceof AddonGeoArmorItem) {
            AddonGeoArmorItem geo = (AddonGeoArmorItem)item;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !entity.m_6844_(slot).m_150930_(item) || entity.m_6844_(slot).m_41619_()) continue;
                long geoId = GeoItem.getId((ItemStack)entity.m_6844_(slot)) + (long)entity.m_19879_();
                AnimationController controller = (AnimationController)geo.getAnimatableInstanceCache().getManagerForId(geoId).getAnimationControllers().get(entry.getProperty(CONTROLLER));
                if (controller == null) continue;
                controller.forceAnimationReset();
                controller.stop();
                controller.tryTriggerAnimation(entry.getProperty(ANIMATION_TRIGGER));
            }
        }
    }
}

