/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.playeranimator;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ParsedAnimationController<T extends GeoAnimatable> {
    private final String name;
    private final int transitionTickTime;
    private final RawAnimation rawAnimation;
    private final PresetType preset;
    private final Map<String, RawAnimation> triggers = new HashMap<String, RawAnimation>();

    public ParsedAnimationController(String name, int transitionTickTime, RawAnimation rawAnimation) {
        this.name = name;
        this.transitionTickTime = transitionTickTime;
        this.rawAnimation = rawAnimation;
        this.preset = null;
    }

    public ParsedAnimationController(PresetType preset) {
        this.name = null;
        this.transitionTickTime = 0;
        this.rawAnimation = null;
        this.preset = preset;
    }

    public ParsedAnimationController<T> triggerableAnim(String key, RawAnimation animation) {
        this.triggers.put(key, animation);
        return this;
    }

    public AnimationController<T> createController(T animatable) {
        AnimationController controller = this.preset != null ? this.preset.createController(animatable) : new AnimationController(animatable, this.name, this.transitionTickTime, animationState -> animationState.setAndContinue(this.rawAnimation));
        for (Map.Entry<String, RawAnimation> e : this.triggers.entrySet()) {
            controller.triggerableAnim(e.getKey(), e.getValue()).receiveTriggeredAnimations();
        }
        return controller;
    }

    @NotNull
    public static <T extends GeoAnimatable> ParsedAnimationController<T> controllerFromJson(JsonObject json) {
        ParsedAnimationController<T> controller;
        if (GsonHelper.m_13900_((JsonObject)json, (String)"preset")) {
            name = GsonHelper.m_13906_((JsonObject)json, (String)"preset");
            PresetType presetType = PresetType.fromName(name);
            if (presetType == null) {
                throw new JsonParseException("Unknown animation controller preset '" + name + "'");
            }
            controller = new ParsedAnimationController<T>(presetType);
        } else {
            name = GsonHelper.m_13906_((JsonObject)json, (String)"name");
            int transitionTicks = GsonUtil.getAsIntMin(json, "transition_tick_time", 0);
            RawAnimation rawAnimation = ParsedAnimationController.animationFromJson(json.get("animation"));
            controller = new ParsedAnimationController<T>(name, transitionTicks, rawAnimation);
        }
        if (GsonHelper.m_13900_((JsonObject)json, (String)"triggers")) {
            JsonObject triggers = GsonHelper.m_13930_((JsonObject)json, (String)"triggers");
            for (Map.Entry e : triggers.entrySet()) {
                controller.triggerableAnim((String)e.getKey(), ParsedAnimationController.animationFromJson((JsonElement)e.getValue()));
            }
        }
        return controller;
    }

    public static RawAnimation animationFromJson(JsonElement element) {
        RawAnimation animation = RawAnimation.begin();
        if (element == null || element.isJsonNull()) {
            return animation;
        }
        if (element.isJsonPrimitive()) {
            animation.thenPlay(element.getAsString());
        } else {
            JsonArray jsonArray = GsonHelper.m_13924_((JsonElement)element, (String)"animation");
            for (JsonElement el : jsonArray) {
                JsonObject step = GsonHelper.m_13918_((JsonElement)el, (String)"animation[].$");
                String type = GsonHelper.m_13906_((JsonObject)step, (String)"type");
                if (type.equalsIgnoreCase("then_play")) {
                    animation.thenPlay(GsonHelper.m_13906_((JsonObject)step, (String)"animation"));
                    continue;
                }
                if (type.equalsIgnoreCase("then_loop")) {
                    animation.thenLoop(GsonHelper.m_13906_((JsonObject)step, (String)"animation"));
                    continue;
                }
                if (type.equalsIgnoreCase("then_wait")) {
                    animation.thenWait(GsonHelper.m_13927_((JsonObject)step, (String)"ticks"));
                    continue;
                }
                if (type.equalsIgnoreCase("then_play_and_hold")) {
                    animation.thenPlayAndHold(GsonHelper.m_13906_((JsonObject)step, (String)"animation"));
                    continue;
                }
                if (!type.equalsIgnoreCase("then_play_x_times")) continue;
                animation.thenPlayXTimes(GsonHelper.m_13906_((JsonObject)step, (String)"animation"), GsonHelper.m_13927_((JsonObject)step, (String)"play_count"));
            }
        }
        return animation;
    }

    public static enum PresetType {
        LIVING("living"),
        IDLE("idle"),
        SNEAK("sneak"),
        CRAWL("crawl"),
        WALK("walk"),
        WALK_OR_ELSE_IDLE("walk_or_else_idle"),
        ATTACK("attack"),
        SWIM("swim"),
        SWIM_OR_ELSE_IDLE("swim_or_else_idle"),
        FLY("fly"),
        FLY_OR_ELSE_IDLE("fly_or_else_idle"),
        WALK_RUN_OR_ELSE_IDLE("walk_run_or_else_idle");

        private final String name;

        private PresetType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public <T extends GeoAnimatable> AnimationController<T> createController(T animatable) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case LIVING -> DefaultAnimations.genericLivingController(animatable);
                case IDLE -> DefaultAnimations.genericIdleController(animatable);
                case SNEAK -> new AnimationController(animatable, "Sneak", 10, state -> state.setAndContinue(DefaultAnimations.SNEAK));
                case CRAWL -> new AnimationController(animatable, "Crawl", 10, state -> state.setAndContinue(DefaultAnimations.CRAWL));
                case WALK -> DefaultAnimations.genericWalkController(animatable);
                case WALK_OR_ELSE_IDLE -> DefaultAnimations.genericWalkIdleController(animatable);
                case ATTACK -> new AnimationController(animatable, "Attack", 5, state -> {
                    Object patt6684$temp = state.getData(DataTickets.ENTITY);
                    if (patt6684$temp instanceof LivingEntity) {
                        LivingEntity living = (LivingEntity)patt6684$temp;
                        if (living.f_20911_) {
                            return state.setAndContinue(DefaultAnimations.ATTACK_SWING);
                        }
                    }
                    state.getController().forceAnimationReset();
                    return PlayState.STOP;
                });
                case SWIM -> DefaultAnimations.genericSwimController(animatable);
                case SWIM_OR_ELSE_IDLE -> DefaultAnimations.genericSwimIdleController(animatable);
                case FLY -> DefaultAnimations.genericFlyController(animatable);
                case FLY_OR_ELSE_IDLE -> DefaultAnimations.genericFlyIdleController(animatable);
                case WALK_RUN_OR_ELSE_IDLE -> new AnimationController(animatable, "Walk/Run/Idle", 0, state -> {
                    if (state.isMoving()) {
                        LivingEntity en;
                        Object patt7554$temp = state.getData(DataTickets.ENTITY);
                        return state.setAndContinue(patt7554$temp instanceof LivingEntity && (en = (LivingEntity)patt7554$temp).m_20142_() ? DefaultAnimations.RUN : DefaultAnimations.WALK);
                    }
                    return state.setAndContinue(DefaultAnimations.IDLE);
                });
            };
        }

        @Nullable
        public static PresetType fromName(String name) {
            for (PresetType presetType : PresetType.values()) {
                if (!presetType.getName().equalsIgnoreCase(name)) continue;
                return presetType;
            }
            return null;
        }
    }
}

