/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.kubejs.condition;

import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.registry.BuilderBase;
import dev.latvian.mods.kubejs.registry.RegistryInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.compat.kubejs.PalladiumKubeJSPlugin;
import net.threetag.palladium.compat.kubejs.ability.AbilityBuilder;
import net.threetag.palladium.compat.kubejs.condition.ScriptableCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PalladiumPropertyLookup;

public class ConditionBuilder
extends BuilderBase<ConditionSerializer> {
    public transient TestFunction test = null;
    public transient String documentationDescription = null;
    public transient List<AbilityBuilder.DeserializePropertyInfo> extraProperties = new ArrayList<AbilityBuilder.DeserializePropertyInfo>();

    public ConditionBuilder(ResourceLocation id) {
        super(id);
    }

    public RegistryInfo<ConditionSerializer> getRegistryType() {
        return PalladiumKubeJSPlugin.CONDITION;
    }

    public ConditionSerializer createObject() {
        return new Serializer(this);
    }

    public ConditionBuilder test(TestFunction testFunction) {
        this.test = testFunction;
        return this;
    }

    public ConditionBuilder addProperty(String key, String type, Object defaultValue, String configureDesc) {
        PalladiumProperty<?> property = PalladiumPropertyLookup.get(type, key);
        if (property != null) {
            this.extraProperties.add(new AbilityBuilder.DeserializePropertyInfo(key, type, defaultValue, configureDesc));
        } else {
            AddonPackLog.error("Failed to register condition property \"%s\", type \"%s\" is not supported", key, type);
        }
        return this;
    }

    public ConditionBuilder documentationDescription(String documentationDescription) {
        this.documentationDescription = documentationDescription;
        return this;
    }

    @FunctionalInterface
    public static interface TestFunction {
        public boolean test(LivingEntity var1, Map<String, Object> var2);
    }

    public static class Serializer
    extends ConditionSerializer {
        public final ConditionBuilder builder;

        public Serializer(ConditionBuilder builder) {
            this.builder = builder;
            for (AbilityBuilder.DeserializePropertyInfo info : this.builder.extraProperties) {
                PalladiumProperty<?> property = PalladiumPropertyLookup.get(info.type, info.key);
                if (info.configureDesc == null || info.configureDesc.isEmpty() || property == null) continue;
                property.configurable(info.configureDesc);
                this.withProperty(property, PalladiumProperty.fixValues(property, info.defaultValue));
            }
        }

        @Override
        public Condition make(JsonObject json) {
            HashMap<String, Object> extraProps = new HashMap<String, Object>();
            for (Map.Entry<PalladiumProperty<?>, Object> propertyEntry : this.getPropertyManager().values().entrySet()) {
                PalladiumProperty<?> property = propertyEntry.getKey();
                extraProps.put(property.getKey(), this.getProperty(json, property));
            }
            return new ScriptableCondition(this.builder, this, extraProps);
        }

        @Override
        public String getDocumentationDescription() {
            return this.builder.documentationDescription;
        }
    }
}

