/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.pehkui;

import java.util.Collection;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.SizeAbility;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladiumcore.event.LivingEntityEvents;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleModifier;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.api.TypedScaleModifier;

public class PehkuiCompat
extends SizeUtil {
    public static final ScaleType ABILITY_SCALE = (ScaleType)ScaleRegistries.register((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)Palladium.id("ability"), (Object)ScaleType.Builder.create().affectsDimensions().build());
    public static final ScaleModifier ABILITY_MODIFIER = (ScaleModifier)ScaleRegistries.register((Map)ScaleRegistries.SCALE_MODIFIERS, (ResourceLocation)Palladium.id("ability"), (Object)new TypedScaleModifier(() -> ABILITY_SCALE));

    public static void init() {
        SizeUtil.setInstance(new PehkuiCompat());
        ScaleTypes.BASE.getDefaultBaseValueModifiers().add(ABILITY_MODIFIER);
        LivingEntityEvents.TICK.register(entity -> {
            float scale = PehkuiCompat.getAbilityMultiplier(entity);
            if (scale != ABILITY_SCALE.getScaleData((Entity)entity).getTargetScale()) {
                ABILITY_SCALE.getScaleData((Entity)entity).setTargetScale(scale);
            }
        });
    }

    public static float getAbilityMultiplier(LivingEntity entity) {
        float f = 1.0f;
        try {
            for (AbilityInstance enabledEntry : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.SIZE.get())) {
                f *= enabledEntry.getProperty(SizeAbility.SCALE).floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return f;
    }

    @Override
    public boolean startScaleChange(Entity entity, ResourceLocation scaleTypeId, float targetScale, int tickDelay) {
        ScaleType scaleType = (ScaleType)ScaleRegistries.getEntry((Map)ScaleRegistries.SCALE_TYPES, (ResourceLocation)scaleTypeId);
        if (scaleType != null) {
            ScaleData data = scaleType.getScaleData(entity);
            data.setScaleTickDelay(tickDelay);
            data.setTargetScale(targetScale);
            return true;
        }
        return false;
    }

    @Override
    public float getWidthScale(Entity entity) {
        return ScaleTypes.HITBOX_WIDTH.getScaleData(entity).getScale();
    }

    @Override
    public float getWidthScale(Entity entity, float delta) {
        return ScaleTypes.HITBOX_WIDTH.getScaleData(entity).getScale(delta);
    }

    @Override
    public float getHeightScale(Entity entity) {
        return ScaleTypes.HITBOX_HEIGHT.getScaleData(entity).getScale();
    }

    @Override
    public float getHeightScale(Entity entity, float delta) {
        return ScaleTypes.HITBOX_HEIGHT.getScaleData(entity).getScale(delta);
    }

    @Override
    public float getModelWidthScale(Entity entity) {
        return ScaleTypes.MODEL_WIDTH.getScaleData(entity).getScale();
    }

    @Override
    public float getModelWidthScale(Entity entity, float delta) {
        return ScaleTypes.MODEL_WIDTH.getScaleData(entity).getScale(delta);
    }

    @Override
    public float getModelHeightScale(Entity entity) {
        return ScaleTypes.MODEL_HEIGHT.getScaleData(entity).getScale();
    }

    @Override
    public float getModelHeightScale(Entity entity, float delta) {
        return ScaleTypes.MODEL_HEIGHT.getScaleData(entity).getScale(delta);
    }

    @Override
    public float getEyeHeightScale(Entity entity) {
        return ScaleTypes.EYE_HEIGHT.getScaleData(entity).getScale();
    }

    @Override
    public float getEyeHeightScale(Entity entity, float delta) {
        return ScaleTypes.EYE_HEIGHT.getScaleData(entity).getScale(delta);
    }

    @Override
    public Collection<ResourceLocation> getScaleTypeIds() {
        return ScaleRegistries.SCALE_TYPES.keySet();
    }
}

