/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.RegistryObjectProperty;

public class HasEffectCondition
extends Condition {
    public final MobEffect mobEffect;

    public HasEffectCondition(MobEffect mobEffect) {
        this.mobEffect = mobEffect;
    }

    @Override
    public boolean active(DataContext context) {
        LivingEntity entity = context.getLivingEntity();
        return entity != null && entity.m_21023_(this.mobEffect);
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.HAS_EFFECT.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<MobEffect> EFFECT = new RegistryObjectProperty("effect", BuiltInRegistries.f_256974_).configurable("ID of the (potion) effect that is being checked for.");

        public Serializer() {
            this.withProperty(EFFECT, MobEffects.f_19614_);
        }

        @Override
        public Condition make(JsonObject json) {
            return new HasEffectCondition(this.getProperty(json, EFFECT));
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the entity has a (potion) effect.";
        }
    }
}

