/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.world.entity.Entity;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.context.DataContextType;

public class IsLevitatingCondition
extends Condition {
    @Override
    public boolean active(DataContext context) {
        Entity entity = context.get(DataContextType.ENTITY);
        if (entity == null) {
            return false;
        }
        if (entity instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)entity;
            float flight = extension.palladium$getFlightHandler().getFlightAnimation(1.0f);
            return flight > 0.0f && flight <= 1.0f;
        }
        return false;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.IS_LEVITATING.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        @Override
        public Condition make(JsonObject json) {
            return new IsLevitatingCondition();
        }

        @Override
        public String getDocumentationDescription() {
            return "Checks if the entity is levitating.";
        }
    }
}

