/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.util.icon.IngredientIcon;
import net.threetag.palladium.util.property.IngredientProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class ItemBuyableCondition
extends BuyableCondition {
    private final Ingredient ingredient;
    private final int amount;

    public ItemBuyableCondition(Ingredient ingredient, int amount) {
        this.ingredient = ingredient;
        this.amount = amount;
    }

    @Override
    public AbilityConfiguration.UnlockData createData() {
        ItemStack[] stacks = this.ingredient.m_43908_();
        MutableComponent component = Component.m_237119_();
        for (int i = 0; i < stacks.length; ++i) {
            component.m_7220_(stacks[i].m_41720_().m_7626_(stacks[i]));
            if (i >= stacks.length - 1) continue;
            if (i == stacks.length - 2) {
                component.m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"gui.palladium.powers.buy_ability.or")).m_130946_(" ");
                continue;
            }
            component.m_130946_(", ");
        }
        return new AbilityConfiguration.UnlockData(new IngredientIcon(this.ingredient), this.amount, (Component)component);
    }

    @Override
    public boolean isAvailable(LivingEntity entity) {
        int found = 0;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!this.ingredient.test(stack)) continue;
                found += stack.m_41613_();
            }
        }
        return found >= this.amount;
    }

    @Override
    public boolean takeFromEntity(LivingEntity entity) {
        int remove = this.amount;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
                ItemStack stack = player.m_150109_().m_8020_(i);
                if (!this.ingredient.test(stack)) continue;
                int willRemove = Math.min(remove, stack.m_41613_());
                player.m_150109_().m_7407_(i, willRemove);
                if ((remove -= willRemove) <= 0) break;
            }
        }
        return remove <= 0;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.ITEM_BUYABLE.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<Ingredient> INGREDIENT = new IngredientProperty("ingredient").configurable("Ingredient predicate for the item");
        public static final PalladiumProperty<Integer> AMOUNT = new IntegerProperty("amount").configurable("Amount of items that the player needs to spend");

        public Serializer() {
            this.withProperty(INGREDIENT, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42416_}));
            this.withProperty(AMOUNT, 3);
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.DATA;
        }

        @Override
        public Condition make(JsonObject json) {
            return new ItemBuyableCondition(this.getProperty(json, INGREDIENT), this.getProperty(json, AMOUNT));
        }

        @Override
        public String getDocumentationDescription() {
            return "The player needs to spend a certain amount of items to unlock the ability.";
        }
    }
}

