/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.data.forge;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraftforge.common.data.LanguageProvider;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.power.ability.Ability;

public abstract class ExtendedLangProvider
extends LanguageProvider {
    public ExtendedLangProvider(PackOutput packOutput, String modid, String locale) {
        super(packOutput, modid, locale);
    }

    public void addAbility(Supplier<? extends Ability> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Ability key, String name) {
        ResourceLocation id = Ability.REGISTRY.getKey((Object)key);
        this.add("ability." + Objects.requireNonNull(id).m_135827_() + "." + id.m_135815_(), name);
    }

    protected void addAccessory(Supplier<? extends Accessory> key, String name) {
        this.add(key.get(), name);
    }

    public void add(Accessory key, String name) {
        ResourceLocation id = Accessory.REGISTRY.getKey((Object)key);
        this.add("accessory." + Objects.requireNonNull(id).m_135827_() + "." + id.m_135815_(), name);
    }

    protected void add(AccessorySlot slot, String name) {
        this.add(slot.getTranslationKey(), name);
    }

    public void addBannerPatternDesc(Supplier<BannerPattern> bannerPattern, DyeColor color, String name) {
        this.addBannerPatternDesc(bannerPattern.get(), color, name);
    }

    public void addBannerPatternDesc(BannerPattern bannerPattern, DyeColor color, String name) {
        ResourceLocation id = BuiltInRegistries.f_256878_.m_7981_((Object)bannerPattern);
        this.add("block.minecraft.banner." + Objects.requireNonNull(id).m_135827_() + "." + id.m_135815_() + "." + color.m_41065_(), name);
    }

    public void add(Attribute key, String name) {
        this.add(key.m_22087_(), name);
    }

    public void addAttribute(Supplier<? extends Attribute> key, String name) {
        this.add(key.get(), name);
    }
}

