/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.data.forge;

import java.util.function.Supplier;
import net.minecraft.data.PackOutput;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.threetag.palladium.accessory.Accessories;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.block.PalladiumBlocks;
import net.threetag.palladium.client.PalladiumKeyMappings;
import net.threetag.palladium.data.forge.ExtendedLangProvider;
import net.threetag.palladium.data.forge.PalladiumSoundDefinitionsProvider;
import net.threetag.palladium.entity.PalladiumAttributes;
import net.threetag.palladium.entity.PalladiumEntityTypes;
import net.threetag.palladium.item.PalladiumItems;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.sound.PalladiumSoundEvents;
import org.jetbrains.annotations.NotNull;

public abstract class PalladiumLangProvider
extends ExtendedLangProvider {
    public PalladiumLangProvider(PackOutput output, String modid, String locale) {
        super(output, modid, locale);
    }

    public PalladiumLangProvider(PackOutput packOutput, String locale) {
        super(packOutput, "palladium", locale);
    }

    @NotNull
    public String m_6055_() {
        return "Palladium " + super.m_6055_();
    }

    public static class Saxon
    extends PalladiumLangProvider {
        public Saxon(PackOutput packOutput) {
            super(packOutput, "sxu");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)PalladiumBlocks.LEAD_ORE, "Ble\u00e4rds");
            this.addBlock((Supplier)PalladiumBlocks.DEEPSLATE_LEAD_ORE, "Diefnschieforr-Ble\u00e4rds");
            this.addBlock((Supplier)PalladiumBlocks.TITANIUM_ORE, "Titanium\u00e4rds");
            this.addBlock((Supplier)PalladiumBlocks.VIBRANIUM_ORE, "Vibranium\u00e4rds");
            this.addBlock((Supplier)PalladiumBlocks.REDSTONE_FLUX_CRYSTAL_GEODE, "Redstone-Flux-Kristallgeode");
            this.addBlock((Supplier)PalladiumBlocks.DEEPSLATE_REDSTONE_FLUX_CRYSTAL_GEODE, "Diefnschieforr-Redstone-Flux-Kristallgeode");
            this.addBlock((Supplier)PalladiumBlocks.SMALL_REDSTONE_FLUX_CRYSTAL_BUD, "Gleene Redstone-Flux-Kristallgnosbe");
            this.addBlock((Supplier)PalladiumBlocks.MEDIUM_REDSTONE_FLUX_CRYSTAL_BUD, "Mittlorre Redstone-Flux-Kristallgnosbe");
            this.addBlock((Supplier)PalladiumBlocks.LARGE_REDSTONE_FLUX_CRYSTAL_BUD, "Gro\u00dfe Redstone-Flux-Kristallgnosbe");
            this.addBlock((Supplier)PalladiumBlocks.REDSTONE_FLUX_CRYSTAL_CLUSTER, "Redstone-Flux-Kristallhaufn");
            this.addBlock((Supplier)PalladiumBlocks.LEAD_BLOCK, "Bleblogg");
            this.addBlock((Supplier)PalladiumBlocks.VIBRANIUM_BLOCK, "Vibraniumblogg");
            this.addBlock((Supplier)PalladiumBlocks.RAW_LEAD_BLOCK, "Rohbleblogg");
            this.addBlock((Supplier)PalladiumBlocks.RAW_TITANIUM_BLOCK, "Rohtitaniumblogg");
            this.addBlock((Supplier)PalladiumBlocks.RAW_VIBRANIUM_BLOCK, "Rohvibraniumblogg");
            this.addBlock((Supplier)PalladiumBlocks.HEART_SHAPED_HERB, "Herzf\u00f6rmijes Graud");
            this.addBlock((Supplier)PalladiumBlocks.POTTED_HEART_SHAPED_HERB, "Eingedobbdes Herzf\u00f6rmije Graud");
            this.addItem((Supplier)PalladiumItems.RAW_LEAD, "Rohble");
            this.addItem((Supplier)PalladiumItems.LEAD_INGOT, "Blebarrn");
            this.addItem((Supplier)PalladiumItems.RAW_TITANIUM, "Rohtitanium");
            this.addItem((Supplier)PalladiumItems.RAW_VIBRANIUM, "Rohvibranium");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_INGOT, "Vibraniumbarrn");
            this.addItem((Supplier)PalladiumItems.REDSTONE_FLUX_CRYSTAL, "Redstone-Flux-Kristall");
            this.addItem((Supplier)PalladiumItems.SUIT_STAND, "Anzuchsschd\u00e4ndorr");
            this.addItem((Supplier)PalladiumItems.LEAD_CIRCUIT, "Redstoneschaldkres");
            this.addItem((Supplier)PalladiumItems.QUARTZ_CIRCUIT, "Quarzschaldkres");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_CIRCUIT, "Vibraniumschaldkres");
            this.addItem((Supplier)PalladiumItems.LEAD_FLUX_CAPACITOR, "Ble-Fluxgompensator");
            this.addItem((Supplier)PalladiumItems.QUARTZ_FLUX_CAPACITOR, "Quarz-Fluxgompensator");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_FLUX_CAPACITOR, "Vibranium-Fluxgompensator");
            this.add("item.palladium.flux_capacitor.desc", "Enerschie: %s / %s RF");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_WEAVE_BOOTS, "Vibraniumjewebelaadschn");
            this.addEntityType((Supplier)PalladiumEntityTypes.EFFECT, "Effekt");
            this.addEntityType((Supplier)PalladiumEntityTypes.CUSTOM_PROJECTILE, "Projektil");
            this.addEntityType((Supplier)PalladiumEntityTypes.SUIT_STAND, "Anzuchsschd\u00e4ndorr");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FLIGHT_SPEED, "Flugjeschwindichket");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.LEVITATION_SPEED, "Schwebejeschwindichket");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FLIGHT_FLEXIBILITY, "Flugflexibilit\u00e4t");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.HEROIC_FLIGHT_TYPE, "Heroischer Flug");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.PUNCH_DAMAGE, "Schlachkraft");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.JUMP_POWER, "Sprungkraft");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.DESTROY_SPEED, "Abbohjeschwindichket");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FALL_RESISTANCE, "Fallwidorstand");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.LEAPING, "Wehtsprung");
            this.add("attribute.name.forge.swim_speed", "Schwimmjeschwindigkeit");
            this.addAbility((Supplier<? extends Ability>)Abilities.DUMMY, "Dummy");
            this.addAbility((Supplier<? extends Ability>)Abilities.COMMAND, "Befehl");
            this.addAbility((Supplier<? extends Ability>)Abilities.RENDER_LAYER, "Render Layer");
            this.addAbility((Supplier<? extends Ability>)Abilities.RENDER_LAYER_BY_ACCESSORY_SLOT, "Render Layer");
            this.addAbility((Supplier<? extends Ability>)Abilities.ANIMATION_TIMER, "Animations-Timer");
            this.addAbility((Supplier<? extends Ability>)Abilities.REPEATING_ANIMATION_TIMER, "Animations-Timer");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHRINK_BODY_OVERLAY, "K\u00f6rperoverlay schrumpfen");
            this.addAbility((Supplier<? extends Ability>)Abilities.ATTRIBUTE_MODIFIER, "\u00c4ttrib\u00fctmodifikator");
            this.addAbility((Supplier<? extends Ability>)Abilities.HEALING, "Helung");
            this.addAbility((Supplier<? extends Ability>)Abilities.SLOWFALL, "Langsamer Fall");
            this.addAbility((Supplier<? extends Ability>)Abilities.DAMAGE_IMMUNITY, "Schadensimmunit\u00e4t");
            this.addAbility((Supplier<? extends Ability>)Abilities.INVISIBILITY, "Unsischtbarkeet");
            this.addAbility((Supplier<? extends Ability>)Abilities.ENERGY_BEAM, "Energiestrahl");
            this.addAbility((Supplier<? extends Ability>)Abilities.SIZE, "Gr\u00f6\u00dfe");
            this.addAbility((Supplier<? extends Ability>)Abilities.PROJECTILE, "Projektil");
            this.addAbility((Supplier<? extends Ability>)Abilities.SKIN_CHANGE, "Skin \u00c4nderung");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAYER_SKIN_CHANGE, "Spieler Skin \u00c4nderung");
            this.addAbility((Supplier<? extends Ability>)Abilities.AIM, "Zielen");
            this.addAbility((Supplier<? extends Ability>)Abilities.HIDE_BODY_PART, "G\u00f6rperdeile versteggen");
            this.addAbility((Supplier<? extends Ability>)Abilities.REMOVE_BODY_PART, "G\u00f6rperdeile entfernen");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHADER_EFFECT, "Shader Effekt");
            this.addAbility((Supplier<? extends Ability>)Abilities.GUI_OVERLAY, "GUI-Overlay");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHOW_BOTH_ARMS, "Beide Arme zeijen");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAYER_ANIMATION, "Spieler-Animation");
            this.addAbility((Supplier<? extends Ability>)Abilities.WATER_WALK, "Uff Wasser Lofen");
            this.addAbility((Supplier<? extends Ability>)Abilities.FLUID_WALKING, "Uff Fl\u00fcssichkeht Lofen");
            this.addAbility((Supplier<? extends Ability>)Abilities.RESTRICT_SLOTS, "Slots beschr\u00e4nken");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAY_SOUND, "Sound");
            this.addAbility((Supplier<? extends Ability>)Abilities.VIBRATE, "Vibrieren");
            this.addAbility((Supplier<? extends Ability>)Abilities.INTANGIBILITY, "Ungreifbarkeht");
            this.addAbility((Supplier<? extends Ability>)Abilities.NAME_CHANGE, "Names\u00e4nderung");
            this.addAbility((Supplier<? extends Ability>)Abilities.SCULK_IMMUNITY, "Sculk-Immunit\u00e4t");
            this.addAbility((Supplier<? extends Ability>)Abilities.FIRE_ASPECT, "Vorbrennung");
            this.addAbility((Supplier<? extends Ability>)Abilities.PARTICLES, "Partikel");
            this.addAbility((Supplier<? extends Ability>)Abilities.IMMORTALITY, "Unsterblichkeht");
            this.addAbility((Supplier<? extends Ability>)Abilities.ENTITY_GLOW, "Leuchten");
            this.addAbility((Supplier<? extends Ability>)Abilities.TOOL_HANDS, "Werkzeuchh\u00e4nde");
            this.addAbility((Supplier<? extends Ability>)Abilities.ABILITY_WHEEL, "F\u00e4hischgehdsrad");
            this.addAbility((Supplier<? extends Ability>)Abilities.DISABLE_HOTBAR_SCROLL, "Scrolling deaktivieren");
            this.add("ability.geckolib.render_layer_animation", "Gecko Render Layer Animation");
            this.add("ability.geckolib.armor_animation", "Gecko Armor Animation");
            this.add("itemGroup.palladium.technology", "Technolojie");
            this.add("itemGroup.palladium.mods", "Palladium Mods");
            this.add("key.palladium.categories.abilities", "F\u00e4hischgehden");
            this.add("key.palladium.switch_ability_list", "F\u00e4hischgehden wechseln");
            this.add("key.palladium.open_equipment", "Equipmend \u00f6ffnen");
            for (int i = 1; i <= PalladiumKeyMappings.ABILITY_KEYS.length; ++i) {
                this.add("key.palladium.ability_" + i, "F\u00e4hischgehd " + i);
            }
            this.add("commands.superpower.error.powerNotFound", "Et wurd' kene Kraft mit'm Namen '%1$s' jefunden");
            this.add("commands.superpower.error.noLivingEntity", "Objekt ist nicht lebend");
            this.add("commands.superpower.error.noSuperpowers", "%s hat kene Supperkr\u00e4fte");
            this.add("commands.superpower.query.success", "%s hat de foljend'n Supperkr\u00e4fte: %s");
            this.add("commands.superpower.success.entity.single", "%s hat de Supperkraft %s erhalten");
            this.add("commands.superpower.success.entity.multiple", "%s Lebewesen haben de Supperkraft %s erhalten");
            this.add("commands.superpower.remove.success.entity.single", "%s's Supperkraft/-kr\u00e4fte wurd' entfernt");
            this.add("commands.superpower.remove.success.entity.multiple", "De Supperkraft/-kr\u00e4fte von %s Lebewesen wurd' entfernt");
            this.add("commands.superpower.replace.success.entity.single", "%s's Supperkraft/-kr\u00e4fte wurd'n ausjetoscht");
            this.add("commands.superpower.replace.success.entity.multiple", "De Supperkraft/-kr\u00e4fte von %s Lebewesen wurd'n ausjetoscht");
            this.add("commands.superpower.error.alreadyHasSuperpower", "%s had berehts dise Supperkraft");
            this.add("commands.superpower.error.doesntHaveSuperpower", "%s had dese Supperkraft nich");
            this.add("commands.ability.error.notUnlockable", "De %s F\u00e4hischgehd von der %s Kraft kann n\u00fcsch freigeschaltet werd'n");
            this.add("commands.ability.error.doesntHavePower", "%s hat diese Kraft n\u00fcsch");
            this.add("commands.ability.locking.success", "De %s F\u00e4hischgehden von der %s Kraft wurd'n f\u00fcr %s Lebewesen jesperrt");
            this.add("commands.ability.locking.all.success", "%s F\u00e4hischgehden von der %s Kraft wurd'n f\u00fcr %s Lebewesen jesperrt");
            this.add("commands.ability.unlocking.success", "De %s F\u00e4hischgehden von der %s Kraft wurd'n f\u00fcr %s Lebewesen freijeschaltet");
            this.add("commands.ability.unlocking.all.success", "%s F\u00e4higkeiten von der %s Kraft wurd'n f\u00fcr %s Lebewesen freijeschaltet");
            this.add("commands.energybar.error.noLivingEntity", "Objekt ist nicht lebend");
            this.add("commands.energybar.error.energyBarNotFound", "Energy-Bar existiert n\u00fcscht");
            this.add("commands.energybar.value.get.success", "%s's Energy-Bar %s#%s is bei %s");
            this.add("commands.energybar.value.set.success", "%s's Energy-Bar %s#%s wurd' uff %s jesetzt");
            this.add("commands.energybar.maxValue.get.success", "%s's Energy-Bar %s#%s hat ehn Maximum von %s");
            this.add("commands.energybar.maxValue.set.success", "%s's Energy-Bar %s#%s wurd' uff ehn Maximum von %s jesetzt");
            this.add("commands.energybar.maxValue.reset.success", "%s's Energy-Bar %s#%s wurd' uff ehn Maximum von %s zur\u00fcckjesetzt");
            this.add("argument.entity.options.palladium.power.description", "Ben\u00f6tichte Kraft");
            this.add("gui.palladium.powers", "Kr\u00e4fte");
            this.add("gui.palladium.powers.buy_ability", "M\u00f6schtest'e disse F\u00e4hischgeht freischaltn?");
            this.add("gui.palladium.powers.buy_ability.or", "oder");
            this.add("gui.palladium.powers.buy_ability.experience_level", "Erfahrungsschdufe");
            this.add("gui.palladium.powers.buy_ability.experience_level_plural", "Erfahrungsschdufen");
            this.add("gui.palladium.accessories", "Zubeh\u00f6r");
            this.add("gui.palladium.addon_pack_log", "Addon Pack Log");
            this.add("gui.palladium.addon_pack_log.search", "Suchen...");
            this.add("gui.palladium.addon_pack_log_entry", "Logeintrag");
            this.add("gui.palladium.addon_pack_log_entry.copy_to_clipboard", "Kopieren");
            this.add("gui.palladium.addon_pack_log_entry.upload_to_mclogs", "Uff mclo.gs hochladen");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.LUCRAFT_ARC_REACTOR, "Lucraft Arc Reactor");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HEROBRINE_EYES, "Herobrineaugen");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.FACE_MASK, "Atemschutzmaske");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.GLASSES_3D, "3D-Brille");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.SUN_GLASSES, "Sonnenbrille");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HEART_GLASSES, "Herzbrille");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.OWCA_FEDORA, "OWCA-Hut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.ELTON_HAT, "Elton-Hut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.STRAWHAT, "Strohhut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.FEZ, "Fez");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.ANTENNA, "Antenne");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.KRUSTY_KRAB_HAT, "Krosse-Krabbe-Hut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.SEA_PICKLE_HAT, "Seegurkenhut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.WINTER_SOLDIER_ARM, "Winter Soldier Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HYPERION_ARM, "Hyperion Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.MECHANICAL_ARM, "Mechanischer Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HAMMOND_CANE, "Hammonds Gehstock");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.WOODEN_LEG, "Holzbehn");
            this.add(AccessorySlot.HAT, "Hut");
            this.add(AccessorySlot.HEAD, "Nischel");
            this.add(AccessorySlot.FACE, "Gusche");
            this.add(AccessorySlot.CHEST, "Brust");
            this.add(AccessorySlot.BACK, "R\u00fcggen");
            this.add(AccessorySlot.MAIN_ARM, "Haupdarm");
            this.add(AccessorySlot.OFF_ARM, "Zwehtarm");
            this.add(AccessorySlot.MAIN_HAND, "Haupthand");
            this.add(AccessorySlot.OFF_HAND, "Zwehthand");
            this.add(AccessorySlot.RIGHT_LEG, "Reschdes Behn");
            this.add(AccessorySlot.LEFT_LEG, "Linges Behn");
            this.add(AccessorySlot.SPECIAL, "Spezial");
            this.add(PalladiumSoundDefinitionsProvider.subtitle(PalladiumSoundEvents.HEAT_VISION), "Hitzeblick");
            this.add("death.attack.palladium.energy_beam", "%1$s wurd durch %2$s von enem Enerchiestrahl oofjel\u00f6st");
        }
    }

    public static class German
    extends PalladiumLangProvider {
        public German(PackOutput packOutput) {
            super(packOutput, "de_de");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)PalladiumBlocks.LEAD_ORE, "Bleierz");
            this.addBlock((Supplier)PalladiumBlocks.DEEPSLATE_LEAD_ORE, "Tiefenschiefer-Bleierz");
            this.addBlock((Supplier)PalladiumBlocks.TITANIUM_ORE, "Titaniumerz");
            this.addBlock((Supplier)PalladiumBlocks.VIBRANIUM_ORE, "Vibraniumerz");
            this.addBlock((Supplier)PalladiumBlocks.REDSTONE_FLUX_CRYSTAL_GEODE, "Redstone-Flux-Kristallgeode");
            this.addBlock((Supplier)PalladiumBlocks.DEEPSLATE_REDSTONE_FLUX_CRYSTAL_GEODE, "Tiefenschiefer-Redstone-Flux-Kristallgeode");
            this.addBlock((Supplier)PalladiumBlocks.SMALL_REDSTONE_FLUX_CRYSTAL_BUD, "Kleine Redstone-Flux-Kristallknospe");
            this.addBlock((Supplier)PalladiumBlocks.MEDIUM_REDSTONE_FLUX_CRYSTAL_BUD, "Mittlere Redstone-Flux-Kristallknospe");
            this.addBlock((Supplier)PalladiumBlocks.LARGE_REDSTONE_FLUX_CRYSTAL_BUD, "Gro\u00dfe Redstone-Flux-Kristallknospe");
            this.addBlock((Supplier)PalladiumBlocks.REDSTONE_FLUX_CRYSTAL_CLUSTER, "Redstone-Flux-Kristallhaufen");
            this.addBlock((Supplier)PalladiumBlocks.LEAD_BLOCK, "Bleiblock");
            this.addBlock((Supplier)PalladiumBlocks.VIBRANIUM_BLOCK, "Vibraniumblock");
            this.addBlock((Supplier)PalladiumBlocks.RAW_LEAD_BLOCK, "Rohbleiblock");
            this.addBlock((Supplier)PalladiumBlocks.RAW_TITANIUM_BLOCK, "Rohtitaniumblock");
            this.addBlock((Supplier)PalladiumBlocks.RAW_VIBRANIUM_BLOCK, "Rohvibraniumblock");
            this.addBlock((Supplier)PalladiumBlocks.HEART_SHAPED_HERB, "Herzf\u00f6rmiges Kraut");
            this.addBlock((Supplier)PalladiumBlocks.POTTED_HEART_SHAPED_HERB, "Eingetopftes Herzf\u00f6rmige Kraut");
            this.addItem((Supplier)PalladiumItems.RAW_LEAD, "Rohblei");
            this.addItem((Supplier)PalladiumItems.LEAD_INGOT, "Bleibarren");
            this.addItem((Supplier)PalladiumItems.RAW_TITANIUM, "Rohtitanium");
            this.addItem((Supplier)PalladiumItems.RAW_VIBRANIUM, "Rohvibranium");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_INGOT, "Vibraniumbarren");
            this.addItem((Supplier)PalladiumItems.REDSTONE_FLUX_CRYSTAL, "Redstone-Flux-Kristall");
            this.addItem((Supplier)PalladiumItems.SUIT_STAND, "Anzugsst\u00e4nder");
            this.addItem((Supplier)PalladiumItems.LEAD_CIRCUIT, "Bleischaltkreis");
            this.addItem((Supplier)PalladiumItems.QUARTZ_CIRCUIT, "Quarzschaltkreis");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_CIRCUIT, "Vibraniumschaltkreis");
            this.addItem((Supplier)PalladiumItems.LEAD_FLUX_CAPACITOR, "Blei-Fluxkompensator");
            this.addItem((Supplier)PalladiumItems.QUARTZ_FLUX_CAPACITOR, "Quarz-Fluxkompensator");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_FLUX_CAPACITOR, "Vibranium-Fluxkompensator");
            this.add("item.palladium.flux_capacitor.desc", "Energie: %s / %s RF");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_WEAVE_BOOTS, "Vibraniumgewebeschuhe");
            this.addEntityType((Supplier)PalladiumEntityTypes.EFFECT, "Effekt");
            this.addEntityType((Supplier)PalladiumEntityTypes.CUSTOM_PROJECTILE, "Projektil");
            this.addEntityType((Supplier)PalladiumEntityTypes.SUIT_STAND, "Anzugsst\u00e4nder");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FLIGHT_SPEED, "Fluggeschwindigkeit");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.LEVITATION_SPEED, "Schwebegeschwindigkeit");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FLIGHT_FLEXIBILITY, "Flugflexibilit\u00e4t");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.HEROIC_FLIGHT_TYPE, "Heroischer Flug");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.PUNCH_DAMAGE, "Schlagkraft");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.JUMP_POWER, "Sprungkraft");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.DESTROY_SPEED, "Abbaugeschwindigkeit");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FALL_RESISTANCE, "Fallwiderstand");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.LEAPING, "Weitsprung");
            this.add("attribute.name.forge.swim_speed", "Schwimmgeschwindigkeit");
            this.addAbility((Supplier<? extends Ability>)Abilities.DUMMY, "Dummy");
            this.addAbility((Supplier<? extends Ability>)Abilities.COMMAND, "Befehl");
            this.addAbility((Supplier<? extends Ability>)Abilities.RENDER_LAYER, "Render Layer");
            this.addAbility((Supplier<? extends Ability>)Abilities.RENDER_LAYER_BY_ACCESSORY_SLOT, "Render Layer");
            this.addAbility((Supplier<? extends Ability>)Abilities.ANIMATION_TIMER, "Animations-Timer");
            this.addAbility((Supplier<? extends Ability>)Abilities.REPEATING_ANIMATION_TIMER, "Animations-Timer");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHRINK_BODY_OVERLAY, "K\u00f6rperoverlay schrumpfen");
            this.addAbility((Supplier<? extends Ability>)Abilities.ATTRIBUTE_MODIFIER, "Attributmodifikator");
            this.addAbility((Supplier<? extends Ability>)Abilities.HEALING, "Heilung");
            this.addAbility((Supplier<? extends Ability>)Abilities.SLOWFALL, "Langsamer Fall");
            this.addAbility((Supplier<? extends Ability>)Abilities.DAMAGE_IMMUNITY, "Schadensimmunit\u00e4t");
            this.addAbility((Supplier<? extends Ability>)Abilities.INVISIBILITY, "Unsichtbarkeit");
            this.addAbility((Supplier<? extends Ability>)Abilities.ENERGY_BEAM, "Energiestrahl");
            this.addAbility((Supplier<? extends Ability>)Abilities.SIZE, "Gr\u00f6\u00dfe");
            this.addAbility((Supplier<? extends Ability>)Abilities.PROJECTILE, "Projektil");
            this.addAbility((Supplier<? extends Ability>)Abilities.SKIN_CHANGE, "Skin \u00c4nderung");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAYER_SKIN_CHANGE, "Spieler Skin \u00c4nderung");
            this.addAbility((Supplier<? extends Ability>)Abilities.AIM, "Zielen");
            this.addAbility((Supplier<? extends Ability>)Abilities.HIDE_BODY_PART, "K\u00f6rperteile verstecken");
            this.addAbility((Supplier<? extends Ability>)Abilities.REMOVE_BODY_PART, "K\u00f6rperteile entfernen");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHADER_EFFECT, "Shader Effekt");
            this.addAbility((Supplier<? extends Ability>)Abilities.GUI_OVERLAY, "GUI-Overlay");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHOW_BOTH_ARMS, "Beide Arme zeigen");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAYER_ANIMATION, "Spieler-Animation");
            this.addAbility((Supplier<? extends Ability>)Abilities.WATER_WALK, "Auf Wasser Laufen");
            this.addAbility((Supplier<? extends Ability>)Abilities.FLUID_WALKING, "Auf Fl\u00fcssigkeit Laufen");
            this.addAbility((Supplier<? extends Ability>)Abilities.RESTRICT_SLOTS, "Slots beschr\u00e4nken");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAY_SOUND, "Sound");
            this.addAbility((Supplier<? extends Ability>)Abilities.VIBRATE, "Vibrieren");
            this.addAbility((Supplier<? extends Ability>)Abilities.INTANGIBILITY, "Ungreifbarkeit");
            this.addAbility((Supplier<? extends Ability>)Abilities.NAME_CHANGE, "Names\u00e4nderung");
            this.addAbility((Supplier<? extends Ability>)Abilities.SCULK_IMMUNITY, "Sculk-Immunit\u00e4t");
            this.addAbility((Supplier<? extends Ability>)Abilities.FIRE_ASPECT, "Verbrennung");
            this.addAbility((Supplier<? extends Ability>)Abilities.PARTICLES, "Partikel");
            this.addAbility((Supplier<? extends Ability>)Abilities.IMMORTALITY, "Unsterblichkeit");
            this.addAbility((Supplier<? extends Ability>)Abilities.ENTITY_GLOW, "Leuchten");
            this.addAbility((Supplier<? extends Ability>)Abilities.TOOL_HANDS, "Werkzeugh\u00e4nde");
            this.addAbility((Supplier<? extends Ability>)Abilities.ABILITY_WHEEL, "F\u00e4higkeitsrad");
            this.addAbility((Supplier<? extends Ability>)Abilities.DISABLE_HOTBAR_SCROLL, "Scrolling deaktivieren");
            this.add("ability.geckolib.render_layer_animation", "Gecko Render Layer Animation");
            this.add("ability.geckolib.armor_animation", "Gecko Armor Animation");
            this.add("itemGroup.palladium.technology", "Technologie");
            this.add("itemGroup.palladium.mods", "Palladium Mods");
            this.add("key.palladium.categories.abilities", "F\u00e4higkeiten");
            this.add("key.palladium.switch_ability_list", "F\u00e4higkeitenliste wechseln");
            this.add("key.palladium.open_equipment", "Equipment \u00f6ffnen");
            for (int i = 1; i <= PalladiumKeyMappings.ABILITY_KEYS.length; ++i) {
                this.add("key.palladium.ability_" + i, "F\u00e4higkeit " + i);
            }
            this.add("commands.superpower.error.powerNotFound", "Es wurde keine Kraft mit dem Namen '%1$s' gefunden");
            this.add("commands.superpower.error.noLivingEntity", "Objekt ist nicht lebend");
            this.add("commands.superpower.error.noSuperpowers", "%s hat keine Superkr\u00e4fte");
            this.add("commands.superpower.query.success", "%s hat die folgenden Superkr\u00e4fte: %s");
            this.add("commands.superpower.success.entity.single", "%s hat die Superkraft %s erhalten");
            this.add("commands.superpower.success.entity.multiple", "%s Lebewesen haben die Superkraft %s erhalten");
            this.add("commands.superpower.remove.success.entity.single", "%s's Superkraft/-kr\u00e4fte wurde entfernt");
            this.add("commands.superpower.remove.success.entity.multiple", "Die Superkraft/-kr\u00e4fte von %s Lebewesen wurde entfernt");
            this.add("commands.superpower.replace.success.entity.single", "%s's Superkraft/-kr\u00e4fte wurden ausgetauscht");
            this.add("commands.superpower.replace.success.entity.multiple", "Die Superkraft/-kr\u00e4fte von %s Lebewesen wurden ausgetauscht");
            this.add("commands.superpower.error.alreadyHasSuperpower", "%s hat bereits diese Superkraft");
            this.add("commands.superpower.error.doesntHaveSuperpower", "%s hat diese Superkraft nicht");
            this.add("commands.ability.error.notUnlockable", "Die %s F\u00e4higkeit von der %s Kraft kann nicht freigeschaltet werden");
            this.add("commands.ability.error.doesntHavePower", "%s hat diese Kraft nicht");
            this.add("commands.ability.locking.success", "Die %s F\u00e4higkeiten von der %s Kraft wurden f\u00fcr %s Lebewesen gesperrt");
            this.add("commands.ability.locking.all.success", "%s F\u00e4higkeiten von der %s Kraft wurden f\u00fcr %s Lebewesen gesperrt");
            this.add("commands.ability.unlocking.success", "Die %s F\u00e4higkeiten von der %s Kraft wurden f\u00fcr %s Lebewesen freigeschaltet");
            this.add("commands.ability.unlocking.all.success", "%s F\u00e4higkeiten von der %s Kraft wurden f\u00fcr %s Lebewesen freigeschaltet");
            this.add("commands.energybar.error.noLivingEntity", "Objekt ist nicht lebend");
            this.add("commands.energybar.error.energyBarNotFound", "Energy-Bar existiert nicht");
            this.add("commands.energybar.value.get.success", "%s's Energy-Bar %s#%s ist bei %s");
            this.add("commands.energybar.value.set.success", "%s's Energy-Bar %s#%s wurde auf %s gesetzt");
            this.add("commands.energybar.maxValue.get.success", "%s's Energy-Bar %s#%s hat ein Maximum von %s");
            this.add("commands.energybar.maxValue.set.success", "%s's Energy-Bar %s#%s wurde auf ein Maximum von %s gesetzt");
            this.add("commands.energybar.maxValue.reset.success", "%s's Energy-Bar %s#%s wurde auf ein Maximum von %s zur\u00fcckgesetzt");
            this.add("argument.entity.options.palladium.power.description", "Ben\u00f6tigte Kraft");
            this.add("gui.palladium.powers", "Kr\u00e4fte");
            this.add("gui.palladium.powers.buy_ability", "M\u00f6chtest du diese F\u00e4higkeit freischalten?");
            this.add("gui.palladium.powers.buy_ability.or", "oder");
            this.add("gui.palladium.powers.buy_ability.experience_level", "Erfahrungsstufe");
            this.add("gui.palladium.powers.buy_ability.experience_level_plural", "Erfahrungsstufen");
            this.add("gui.palladium.accessories", "Zubeh\u00f6r");
            this.add("gui.palladium.addon_pack_log", "Addon Pack Log");
            this.add("gui.palladium.addon_pack_log.search", "Suchen...");
            this.add("gui.palladium.addon_pack_log_entry", "Logeintrag");
            this.add("gui.palladium.addon_pack_log_entry.copy_to_clipboard", "Kopieren");
            this.add("gui.palladium.addon_pack_log_entry.upload_to_mclogs", "Auf mclo.gs hochladen");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.LUCRAFT_ARC_REACTOR, "Lucraft Arc Reactor");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HEROBRINE_EYES, "Herobrineaugen");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.FACE_MASK, "Atemschutzmaske");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.GLASSES_3D, "3D-Brille");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.SUN_GLASSES, "Sonnenbrille");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HEART_GLASSES, "Herzbrille");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.OWCA_FEDORA, "OWCA-Hut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.ELTON_HAT, "Elton-Hut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.STRAWHAT, "Strohhut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.FEZ, "Fez");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.ANTENNA, "Antenne");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.KRUSTY_KRAB_HAT, "Krosse-Krabbe-Hut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.SEA_PICKLE_HAT, "Seegurkenhut");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.WINTER_SOLDIER_ARM, "Winter Soldier Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HYPERION_ARM, "Hyperion Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.MECHANICAL_ARM, "Mechanischer Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HAMMOND_CANE, "Hammonds Gehstock");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.WOODEN_LEG, "Holzbein");
            this.add(AccessorySlot.HAT, "Hut");
            this.add(AccessorySlot.HEAD, "Kopf");
            this.add(AccessorySlot.FACE, "Gesicht");
            this.add(AccessorySlot.CHEST, "Brust");
            this.add(AccessorySlot.BACK, "R\u00fccken");
            this.add(AccessorySlot.MAIN_ARM, "Hauptarm");
            this.add(AccessorySlot.OFF_ARM, "Zweitarm");
            this.add(AccessorySlot.MAIN_HAND, "Haupthand");
            this.add(AccessorySlot.OFF_HAND, "Zweithand");
            this.add(AccessorySlot.RIGHT_LEG, "Rechtes Bein");
            this.add(AccessorySlot.LEFT_LEG, "Linkes Bein");
            this.add(AccessorySlot.SPECIAL, "Spezial");
            this.add(PalladiumSoundDefinitionsProvider.subtitle(PalladiumSoundEvents.HEAT_VISION), "Hitzeblick");
            this.add("death.attack.palladium.energy_beam", "%1$s wurde durch %2$s von einem Energiestrahl aufgel\u00f6st");
        }
    }

    public static class English
    extends PalladiumLangProvider {
        public English(PackOutput packOutput) {
            super(packOutput, "en_us");
        }

        protected void addTranslations() {
            this.addBlock((Supplier)PalladiumBlocks.LEAD_ORE, "Lead Ore");
            this.addBlock((Supplier)PalladiumBlocks.DEEPSLATE_LEAD_ORE, "Deepslate Lead Ore");
            this.addBlock((Supplier)PalladiumBlocks.TITANIUM_ORE, "Titanium Ore");
            this.addBlock((Supplier)PalladiumBlocks.VIBRANIUM_ORE, "Vibranium Ore");
            this.addBlock((Supplier)PalladiumBlocks.REDSTONE_FLUX_CRYSTAL_GEODE, "Redstone Flux Crystal Geode");
            this.addBlock((Supplier)PalladiumBlocks.DEEPSLATE_REDSTONE_FLUX_CRYSTAL_GEODE, "Deepslate Redstone Flux Crystal Geode");
            this.addBlock((Supplier)PalladiumBlocks.SMALL_REDSTONE_FLUX_CRYSTAL_BUD, "Small Redstone Flux Crystal Bud");
            this.addBlock((Supplier)PalladiumBlocks.MEDIUM_REDSTONE_FLUX_CRYSTAL_BUD, "Medium Redstone Flux Crystal Bud");
            this.addBlock((Supplier)PalladiumBlocks.LARGE_REDSTONE_FLUX_CRYSTAL_BUD, "Large Redstone Flux Crystal Bud");
            this.addBlock((Supplier)PalladiumBlocks.REDSTONE_FLUX_CRYSTAL_CLUSTER, "Redstone Flux Crystal Cluster");
            this.addBlock((Supplier)PalladiumBlocks.LEAD_BLOCK, "Block of Lead");
            this.addBlock((Supplier)PalladiumBlocks.VIBRANIUM_BLOCK, "Block of Vibranium");
            this.addBlock((Supplier)PalladiumBlocks.RAW_LEAD_BLOCK, "Block of Raw Lead");
            this.addBlock((Supplier)PalladiumBlocks.RAW_TITANIUM_BLOCK, "Block of Raw Titanium");
            this.addBlock((Supplier)PalladiumBlocks.RAW_VIBRANIUM_BLOCK, "Block of Raw Vibranium");
            this.addBlock((Supplier)PalladiumBlocks.HEART_SHAPED_HERB, "Heart-Shaped Herb");
            this.addBlock((Supplier)PalladiumBlocks.POTTED_HEART_SHAPED_HERB, "Potted Heart-Shaped Herb");
            this.addItem((Supplier)PalladiumItems.RAW_LEAD, "Raw Lead");
            this.addItem((Supplier)PalladiumItems.LEAD_INGOT, "Lead Ingot");
            this.addItem((Supplier)PalladiumItems.RAW_TITANIUM, "Raw Titanium");
            this.addItem((Supplier)PalladiumItems.RAW_VIBRANIUM, "Raw Vibranium");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_INGOT, "Vibranium Ingot");
            this.addItem((Supplier)PalladiumItems.REDSTONE_FLUX_CRYSTAL, "Redstone Flux Crystal");
            this.addItem((Supplier)PalladiumItems.SUIT_STAND, "Suit Stand");
            this.addItem((Supplier)PalladiumItems.LEAD_CIRCUIT, "Lead Circuit");
            this.addItem((Supplier)PalladiumItems.QUARTZ_CIRCUIT, "Quartz Circuit");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_CIRCUIT, "Vibranium Circuit");
            this.addItem((Supplier)PalladiumItems.LEAD_FLUX_CAPACITOR, "Lead Flux Capacitor");
            this.addItem((Supplier)PalladiumItems.QUARTZ_FLUX_CAPACITOR, "Quartz Flux Capacitor");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_FLUX_CAPACITOR, "Vibranium Flux Capacitor");
            this.add("item.palladium.flux_capacitor.desc", "Energy: %s / %s RF");
            this.addItem((Supplier)PalladiumItems.VIBRANIUM_WEAVE_BOOTS, "Vibranium Weave Boots");
            this.addEntityType((Supplier)PalladiumEntityTypes.EFFECT, "Effect");
            this.addEntityType((Supplier)PalladiumEntityTypes.CUSTOM_PROJECTILE, "Projectile");
            this.addEntityType((Supplier)PalladiumEntityTypes.SUIT_STAND, "Suit Stand");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FLIGHT_SPEED, "Flight Speed");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.LEVITATION_SPEED, "Levitation Speed");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FLIGHT_FLEXIBILITY, "Flight Flexibility");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.HEROIC_FLIGHT_TYPE, "Heroic Flight");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.PUNCH_DAMAGE, "Punch Damage");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.JUMP_POWER, "Jump Power");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.DESTROY_SPEED, "Destroy Speed");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.FALL_RESISTANCE, "Fall Resistance");
            this.addAttribute((Supplier<? extends Attribute>)PalladiumAttributes.LEAPING, "Leaping");
            this.add("attribute.name.forge.swim_speed", "Swim Speed");
            this.addAbility((Supplier<? extends Ability>)Abilities.DUMMY, "Dummy");
            this.addAbility((Supplier<? extends Ability>)Abilities.COMMAND, "Command");
            this.addAbility((Supplier<? extends Ability>)Abilities.RENDER_LAYER, "Render Layer");
            this.addAbility((Supplier<? extends Ability>)Abilities.RENDER_LAYER_BY_ACCESSORY_SLOT, "Render Layer");
            this.addAbility((Supplier<? extends Ability>)Abilities.ANIMATION_TIMER, "Animation Timer");
            this.addAbility((Supplier<? extends Ability>)Abilities.REPEATING_ANIMATION_TIMER, "Animation Timer");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHRINK_BODY_OVERLAY, "Shrink Body Overlay");
            this.addAbility((Supplier<? extends Ability>)Abilities.ATTRIBUTE_MODIFIER, "Attribute Modifier");
            this.addAbility((Supplier<? extends Ability>)Abilities.HEALING, "Healing");
            this.addAbility((Supplier<? extends Ability>)Abilities.SLOWFALL, "Slowfall");
            this.addAbility((Supplier<? extends Ability>)Abilities.DAMAGE_IMMUNITY, "Damage Immunity");
            this.addAbility((Supplier<? extends Ability>)Abilities.INVISIBILITY, "Invisibility");
            this.addAbility((Supplier<? extends Ability>)Abilities.ENERGY_BEAM, "Energy Beam");
            this.addAbility((Supplier<? extends Ability>)Abilities.SIZE, "Size");
            this.addAbility((Supplier<? extends Ability>)Abilities.PROJECTILE, "Projectile");
            this.addAbility((Supplier<? extends Ability>)Abilities.SKIN_CHANGE, "Skin Change");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAYER_SKIN_CHANGE, "Player Skin Change");
            this.addAbility((Supplier<? extends Ability>)Abilities.AIM, "Aim");
            this.addAbility((Supplier<? extends Ability>)Abilities.HIDE_BODY_PART, "Hide Body Part");
            this.addAbility((Supplier<? extends Ability>)Abilities.REMOVE_BODY_PART, "Remove Body Part");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHADER_EFFECT, "Shader Effect");
            this.addAbility((Supplier<? extends Ability>)Abilities.GUI_OVERLAY, "Gui Overlay");
            this.addAbility((Supplier<? extends Ability>)Abilities.SHOW_BOTH_ARMS, "Show Both Arms");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAYER_ANIMATION, "Player Animation");
            this.addAbility((Supplier<? extends Ability>)Abilities.WATER_WALK, "Water Walk");
            this.addAbility((Supplier<? extends Ability>)Abilities.FLUID_WALKING, "Fluid Walking");
            this.addAbility((Supplier<? extends Ability>)Abilities.RESTRICT_SLOTS, "Restrict Slots");
            this.addAbility((Supplier<? extends Ability>)Abilities.PLAY_SOUND, "Sound");
            this.addAbility((Supplier<? extends Ability>)Abilities.VIBRATE, "Vibrate");
            this.addAbility((Supplier<? extends Ability>)Abilities.INTANGIBILITY, "Intangibility");
            this.addAbility((Supplier<? extends Ability>)Abilities.NAME_CHANGE, "Name Change");
            this.addAbility((Supplier<? extends Ability>)Abilities.SCULK_IMMUNITY, "Sculk Immunity");
            this.addAbility((Supplier<? extends Ability>)Abilities.FIRE_ASPECT, "Fire Aspect");
            this.addAbility((Supplier<? extends Ability>)Abilities.PARTICLES, "Particles");
            this.addAbility((Supplier<? extends Ability>)Abilities.IMMORTALITY, "Immortality");
            this.addAbility((Supplier<? extends Ability>)Abilities.ENTITY_GLOW, "Glow");
            this.addAbility((Supplier<? extends Ability>)Abilities.TOOL_HANDS, "Tool Hands");
            this.addAbility((Supplier<? extends Ability>)Abilities.ABILITY_WHEEL, "Ability Wheel");
            this.addAbility((Supplier<? extends Ability>)Abilities.DISABLE_HOTBAR_SCROLL, "Disable Hotbar Scroll");
            this.add("ability.geckolib.render_layer_animation", "Gecko Render Layer Animation");
            this.add("ability.geckolib.armor_animation", "Gecko Armor Animation");
            this.add("itemGroup.palladium.technology", "Technology");
            this.add("itemGroup.palladium.mods", "Palladium Mods");
            this.add("key.palladium.categories.abilities", "Abilities");
            this.add("key.palladium.switch_ability_list", "Switch Ability List");
            this.add("key.palladium.open_equipment", "Open Equipment");
            for (int i = 1; i <= PalladiumKeyMappings.ABILITY_KEYS.length; ++i) {
                this.add("key.palladium.ability_" + i, "Ability " + i);
            }
            this.add("commands.superpower.error.powerNotFound", "No power was found by the name '%1$s'");
            this.add("commands.superpower.error.noLivingEntity", "This entity is not a living entity");
            this.add("commands.superpower.error.noSuperpowers", "%s has no superpowers");
            this.add("commands.superpower.query.success", "%s has the following superpowers: %s");
            this.add("commands.superpower.success.entity.single", "%s has gained the superpower %s");
            this.add("commands.superpower.success.entity.multiple", "%s entities have gained the superpower %s");
            this.add("commands.superpower.remove.success.entity.single", "%s's superpower(s) was removed");
            this.add("commands.superpower.remove.success.entity.multiple", "The superpower(s) of %s entities was removed");
            this.add("commands.superpower.replace.success.entity.single", "%s's superpower(s) have been replaced");
            this.add("commands.superpower.replace.success.entity.multiple", "The superpower(s) of %s entities have been replaced");
            this.add("commands.superpower.error.alreadyHasSuperpower", "%s already has that superpower");
            this.add("commands.superpower.error.doesntHaveSuperpower", "%s does not have that superpower");
            this.add("commands.ability.error.notUnlockable", "The %s ability of the %s power is not unlockable");
            this.add("commands.ability.error.doesntHavePower", "%s does not have that power");
            this.add("commands.ability.locking.success", "The %s abilities of the %s power have been locked for %s entities");
            this.add("commands.ability.locking.all.success", "%s abilities of the %s powers in %s entities have been locked");
            this.add("commands.ability.unlocking.success", "The %s abilities of the %s power have been unlocked for %s entities");
            this.add("commands.ability.unlocking.all.success", "%s abilities of the %s powers in %s entities have been unlocked");
            this.add("commands.energybar.error.noLivingEntity", "This entity is not a living entity");
            this.add("commands.energybar.error.energyBarNotFound", "Energy bar does not exist");
            this.add("commands.energybar.value.get.success", "%s's energy bar %s#%s is at %s");
            this.add("commands.energybar.value.set.success", "%s's energy bar %s#%s was set to %s");
            this.add("commands.energybar.maxValue.get.success", "%s's energy bar %s#%s has a maximum of %s");
            this.add("commands.energybar.maxValue.set.success", "%s's energy bar %s#%s was set to have a maximum of %s");
            this.add("commands.energybar.maxValue.reset.success", "%s's energy bar %s#%s was reset to have a maximum of %s");
            this.add("argument.entity.options.palladium.power.description", "Required power");
            this.add("gui.palladium.powers", "Powers");
            this.add("gui.palladium.powers.buy_ability", "Do you want to unlock this ability?");
            this.add("gui.palladium.powers.buy_ability.or", "or");
            this.add("gui.palladium.powers.buy_ability.experience_level", "Experience level");
            this.add("gui.palladium.powers.buy_ability.experience_level_plural", "Experience level");
            this.add("gui.palladium.accessories", "Accessories");
            this.add("gui.palladium.addon_pack_log", "Addon Pack Log");
            this.add("gui.palladium.addon_pack_log.search", "Search...");
            this.add("gui.palladium.addon_pack_log_entry", "Log Entry");
            this.add("gui.palladium.addon_pack_log_entry.copy_to_clipboard", "Copy to Clipboard");
            this.add("gui.palladium.addon_pack_log_entry.upload_to_mclogs", "Upload to mclo.gs");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.LUCRAFT_ARC_REACTOR, "Lucraft Arc Reactor");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HEROBRINE_EYES, "Herobrine Eyes");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.FACE_MASK, "Face Mask");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.GLASSES_3D, "3D Glasses");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.SUN_GLASSES, "Sun Glasses");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HEART_GLASSES, "Heart Glasses");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.OWCA_FEDORA, "OWCA Fedora");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.ELTON_HAT, "Elton Hat");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.STRAWHAT, "Strawhat");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.FEZ, "Fez");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.ANTENNA, "Antenna");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.KRUSTY_KRAB_HAT, "Krusty Krab Hat");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.SEA_PICKLE_HAT, "Sea Pickle Hat");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.WINTER_SOLDIER_ARM, "Winter Soldier Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HYPERION_ARM, "Hyperion Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.MECHANICAL_ARM, "Mechanical Arm");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.HAMMOND_CANE, "Hammond Cane");
            this.addAccessory((Supplier<? extends Accessory>)Accessories.WOODEN_LEG, "Wooden Leg");
            this.add(AccessorySlot.HAT, "Hat");
            this.add(AccessorySlot.HEAD, "Head");
            this.add(AccessorySlot.FACE, "Face");
            this.add(AccessorySlot.CHEST, "Chest");
            this.add(AccessorySlot.BACK, "Back");
            this.add(AccessorySlot.MAIN_ARM, "Main Arm");
            this.add(AccessorySlot.OFF_ARM, "Off Arm");
            this.add(AccessorySlot.MAIN_HAND, "Main Hand");
            this.add(AccessorySlot.OFF_HAND, "Off Hand");
            this.add(AccessorySlot.RIGHT_LEG, "Right Leg");
            this.add(AccessorySlot.LEFT_LEG, "Left Leg");
            this.add(AccessorySlot.SPECIAL, "Special");
            this.add(PalladiumSoundDefinitionsProvider.subtitle(PalladiumSoundEvents.HEAT_VISION), "Heat Vision");
            this.add("death.attack.palladium.energy_beam", "%1$s was disintegrated by %2$s");
        }
    }
}

