/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity.effect;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.entity.EffectEntity;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladiumcore.registry.PalladiumRegistry;

public abstract class EntityEffect {
    public static final PalladiumRegistry<EntityEffect> REGISTRY = PalladiumRegistry.create(EntityEffect.class, (ResourceLocation)Palladium.id("entity_effects"));
    public static final PalladiumProperty<Boolean> IS_DONE_PLAYING = new BooleanProperty("is_done_playing");

    public void registerProperties(PropertyManager manager) {
        manager.register(IS_DONE_PLAYING, false);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void render(EffectEntity var1, Entity var2, PoseStack var3, MultiBufferSource var4, int var5, boolean var6, float var7);

    public abstract void tick(EffectEntity var1, Entity var2);

    public boolean isInRangeToRenderDist(EffectEntity effectEntity, Entity anchor, double distance) {
        return anchor.m_6783_(distance);
    }

    public <T> T get(EffectEntity entity, PalladiumProperty<T> property) {
        return property.get(entity);
    }

    public <T> void set(EffectEntity entity, PalladiumProperty<T> property, T value) {
        property.set(entity, value);
    }

    public boolean isPlaying(EffectEntity entity) {
        return this.get(entity, IS_DONE_PLAYING) == false;
    }

    public void stopPlaying(EffectEntity entity) {
        this.set(entity, IS_DONE_PLAYING, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void start(Entity anchor, EntityEffect entityEffect) {
        EffectEntity effectEntity = new EffectEntity(anchor.m_9236_(), anchor, entityEffect);
        Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_104627_(0, (Entity)effectEntity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void stop(Entity anchor, Predicate<EntityEffect> predicate) {
        anchor.m_9236_().m_6249_(anchor, anchor.m_20191_().m_82400_(2.0), entity -> entity instanceof EffectEntity && ((EffectEntity)((Object)entity)).getAnchorEntity() == anchor && predicate.test(((EffectEntity)entity).entityEffect)).forEach(Entity::m_146870_);
    }

    public static void stop(Entity anchor, EntityEffect entityEffectType) {
        EntityEffect.stop(anchor, (EntityEffect effect) -> effect == entityEffectType);
    }
}

