/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.forge;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.NewRegistryEvent;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.PalladiumClient;
import net.threetag.palladium.PalladiumConfig;
import net.threetag.palladium.addonpack.AddonPackManager;
import net.threetag.palladium.block.PalladiumBlocks;
import net.threetag.palladium.client.model.ModelLayerManager;
import net.threetag.palladium.compat.curios.forge.CuriosCompat;
import net.threetag.palladium.compat.geckolib.forge.GeckoLibCompatImpl;
import net.threetag.palladium.data.forge.PalladiumBlockStateProvider;
import net.threetag.palladium.data.forge.PalladiumBlockTagsProvider;
import net.threetag.palladium.data.forge.PalladiumDamageTypeProvider;
import net.threetag.palladium.data.forge.PalladiumItemModelProvider;
import net.threetag.palladium.data.forge.PalladiumItemTagsProvider;
import net.threetag.palladium.data.forge.PalladiumLangProvider;
import net.threetag.palladium.data.forge.PalladiumLootTableProvider;
import net.threetag.palladium.data.forge.PalladiumRecipeProvider;
import net.threetag.palladium.data.forge.PalladiumSoundDefinitionsProvider;
import net.threetag.palladium.data.forge.PalladiumWorldGenProvider;
import net.threetag.palladium.mixin.ReloadableResourceManagerMixin;
import net.threetag.palladiumcore.forge.PalladiumCoreForge;
import net.threetag.palladiumcore.util.Platform;

@Mod(value="palladium")
@Mod.EventBusSubscriber(modid="palladium", bus=Mod.EventBusSubscriber.Bus.MOD)
public class PalladiumForge {
    public PalladiumForge() {
        PalladiumCoreForge.registerModEventBus((String)"palladium", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        if (Platform.isModLoaded((String)"curios")) {
            PalladiumCoreForge.registerModEventBus((String)"curios", (IEventBus)FMLJavaModLoadingContext.get().getModEventBus());
        }
        Palladium.init();
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PalladiumConfig.Client.generateConfig());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)PalladiumConfig.Server.generateConfig());
        if (ModList.get().isLoaded("curios")) {
            CuriosCompat.init();
        }
        if (Platform.isModLoaded((String)"geckolib")) {
            GeckoLibCompatImpl.init();
        }
        if (Platform.isClient()) {
            PalladiumClient.init();
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.initClient();
            }
        }
    }

    @SubscribeEvent
    public static void newRegistry(NewRegistryEvent e) {
        AddonPackManager.waitForLoading();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onConstructMod(FMLConstructModEvent event) {
        event.enqueueWork(AddonPackManager::startLoading);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent e) {
        ((FlowerPotBlock)Blocks.f_50276_).addPlant(PalladiumBlocks.HEART_SHAPED_HERB.getId(), PalladiumBlocks.POTTED_HEART_SHAPED_HERB);
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent e) {
        Palladium.generateDocumentation();
        PackOutput output = e.getGenerator().getPackOutput();
        PalladiumBlockTagsProvider blockTagsProvider = new PalladiumBlockTagsProvider(output, e.getLookupProvider(), e.getExistingFileHelper());
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)blockTagsProvider);
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new PalladiumItemTagsProvider(output, e.getLookupProvider(), e.getExistingFileHelper()));
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new PalladiumRecipeProvider(output));
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new PalladiumLootTableProvider(output));
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new PalladiumWorldGenProvider(output, e.getLookupProvider()));
        e.getGenerator().addProvider(e.includeServer(), (DataProvider)new PalladiumDamageTypeProvider(output, e.getExistingFileHelper()));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new PalladiumBlockStateProvider(output, e.getExistingFileHelper()));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new PalladiumItemModelProvider(output, e.getExistingFileHelper()));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new PalladiumSoundDefinitionsProvider(output, e.getExistingFileHelper()));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new PalladiumLangProvider.English(output));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new PalladiumLangProvider.German(output));
        e.getGenerator().addProvider(e.includeClient(), (DataProvider)new PalladiumLangProvider.Saxon(output));
    }

    @SubscribeEvent
    public static void packFinder(AddPackFindersEvent e) {
        if (e.getPackType() != AddonPackManager.getPackType()) {
            e.addRepositorySource(AddonPackManager.getInstance().getWrappedPackFinder());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRegisterClientReloadListeners(RegisterClientReloadListenersEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        List<PreparableReloadListener> listeners = ((ReloadableResourceManagerMixin)mc.m_91098_()).getListeners();
        int idx = listeners.indexOf(mc.m_167973_());
        listeners.add(idx + 1, (PreparableReloadListener)new ModelLayerManager());
    }
}

