/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.ItemParser;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.item.AddonItem;
import net.threetag.palladium.item.IAddonItem;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class AddonProjectileItem
extends AddonItem {
    private final ResourceLocation entityTypeId;
    private final CompoundTag entityData;

    public AddonProjectileItem(ResourceLocation entityTypeId, CompoundTag entityData, Item.Properties properties) {
        super(properties);
        this.entityTypeId = entityTypeId;
        this.entityData = entityData;
    }

    @Nullable
    public Projectile createProjectile(Level level, ItemStack stack, LivingEntity shooter) {
        Projectile projectile;
        CompoundTag compound = this.entityData == null ? new CompoundTag() : this.entityData;
        compound.m_128359_("id", this.entityTypeId.toString());
        ServerLevel world = (ServerLevel)shooter.m_9236_();
        Entity entity = EntityType.m_20645_((CompoundTag)compound, (Level)world, en -> {
            if (!(en instanceof Projectile)) {
                return null;
            }
            Projectile projectile = (Projectile)en;
            projectile.m_7678_(shooter.m_20185_(), shooter.m_20186_() + (double)shooter.m_20192_() - 0.1, shooter.m_20189_(), projectile.m_146908_(), projectile.m_146909_());
            projectile.m_5602_((Entity)shooter);
            return projectile;
        });
        return entity instanceof Projectile ? (projectile = (Projectile)entity) : null;
    }

    public static class Parser
    implements ItemParser.ItemTypeSerializer {
        @Override
        public IAddonItem parse(JsonObject json, Item.Properties properties) {
            ResourceLocation entityTypeId = GsonUtil.getAsResourceLocation(json, "entity_type", Palladium.id("custom_projectile"));
            CompoundTag entityData = null;
            if (json.has("entity_data")) {
                try {
                    entityData = TagParser.m_129359_((String)GsonHelper.m_13918_((JsonElement)json.get("entity_data"), (String)"entity_data").toString());
                }
                catch (CommandSyntaxException e) {
                    AddonPackLog.warning("Failed to read entity_data for projectile item: " + e.getMessage(), new Object[0]);
                }
            }
            return new AddonProjectileItem(entityTypeId, entityData, properties);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Projectile Item");
            builder.setDescription("If added to the item tag for a bow or a crossbow, this item type can used as ammunitation to shoot pre-defined projectiles.");
            builder.addProperty("entity_type", ResourceLocation.class).description("ID of the entity type that should be shot. Only projectile entity works, like arrows, snowballs, or Palladium's custom projectile").fallback(Palladium.id("custom_projectile")).exampleJson((JsonElement)new JsonPrimitive(Palladium.id("custom_projectile").toString()));
            builder.addProperty("entity_data", CompoundTag.class).description("Custom NBT data for the shot entity").fallback(null).exampleJson((JsonElement)new JsonObject());
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("projectile");
        }
    }
}

