/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.item;

import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.threetag.palladium.Palladium;
import net.threetag.palladiumcore.registry.PalladiumRegistry;
import org.jetbrains.annotations.Nullable;

public class SuitSet {
    public static final PalladiumRegistry<SuitSet> REGISTRY = PalladiumRegistry.create(SuitSet.class, (ResourceLocation)Palladium.id("suit_set"));
    private final Supplier<Item> mainHand;
    private final Supplier<Item> offHand;
    private final Supplier<Item> helmet;
    private final Supplier<Item> chestplate;
    private final Supplier<Item> leggings;
    private final Supplier<Item> boots;
    @Nullable
    private String descriptionId;

    public SuitSet(@Nullable Supplier<Item> mainHand, @Nullable Supplier<Item> offHand, @Nullable Supplier<Item> helmet, @Nullable Supplier<Item> chestplate, @Nullable Supplier<Item> leggings, @Nullable Supplier<Item> boots) {
        this.mainHand = mainHand;
        this.offHand = offHand;
        this.helmet = helmet;
        this.chestplate = chestplate;
        this.leggings = leggings;
        this.boots = boots;
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    protected String getOrCreateDescriptionId() {
        if (this.descriptionId == null) {
            this.descriptionId = Util.m_137492_((String)"suitset", (ResourceLocation)REGISTRY.getKey((Object)this));
        }
        return this.descriptionId;
    }

    @Nullable
    public Item getMainHand() {
        return this.mainHand != null ? this.mainHand.get() : null;
    }

    @Nullable
    public Item getOffHand() {
        return this.offHand != null ? this.offHand.get() : null;
    }

    @Nullable
    public Item getHelmet() {
        return this.helmet != null ? this.helmet.get() : null;
    }

    @Nullable
    public Item getChestplate() {
        return this.chestplate != null ? this.chestplate.get() : null;
    }

    @Nullable
    public Item getLeggings() {
        return this.leggings != null ? this.leggings.get() : null;
    }

    @Nullable
    public Item getBoots() {
        return this.boots != null ? this.boots.get() : null;
    }

    public boolean isWearing(LivingEntity entity) {
        if (this.getChestplate() != null && !entity.m_6844_(EquipmentSlot.CHEST).m_150930_(this.getChestplate())) {
            return false;
        }
        if (this.getMainHand() != null && !entity.m_6844_(EquipmentSlot.MAINHAND).m_150930_(this.getMainHand())) {
            return false;
        }
        if (this.getOffHand() != null && !entity.m_6844_(EquipmentSlot.OFFHAND).m_150930_(this.getOffHand())) {
            return false;
        }
        if (this.getHelmet() != null && !entity.m_6844_(EquipmentSlot.HEAD).m_150930_(this.getHelmet())) {
            return false;
        }
        if (this.getLeggings() != null && !entity.m_6844_(EquipmentSlot.LEGS).m_150930_(this.getLeggings())) {
            return false;
        }
        return this.getBoots() == null || entity.m_6844_(EquipmentSlot.FEET).m_150930_(this.getBoots());
    }
}

