/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.item.AddonProjectileItem;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CrossbowItem.class})
public class CrossbowItemMixin {
    @Inject(at={@At(value="HEAD")}, method={"shootProjectile"})
    private static void shootProjectile(Level level, LivingEntity shooter, InteractionHand hand, ItemStack crossbowStack, ItemStack ammoStack, float soundPitch, boolean isCreativeMode, float velocity, float inaccuracy, float projectileAngle, CallbackInfo ci) {
        Item item;
        if (!level.f_46443_ && (item = ammoStack.m_41720_()) instanceof AddonProjectileItem) {
            AddonProjectileItem projectileItem = (AddonProjectileItem)item;
            Projectile projectile = projectileItem.createProjectile(level, ammoStack, shooter);
            if (shooter instanceof CrossbowAttackMob) {
                CrossbowAttackMob crossbowAttackMob = (CrossbowAttackMob)shooter;
                crossbowAttackMob.m_5811_(crossbowAttackMob.m_5448_(), crossbowStack, projectile, projectileAngle);
            } else {
                Vec3 vec3 = shooter.m_20289_(1.0f);
                Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(projectileAngle * ((float)Math.PI / 180)), vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                Vec3 vec32 = shooter.m_20252_(1.0f);
                Vector3f vector3f = vec32.m_252839_().rotate((Quaternionfc)quaternionf);
                projectile.m_6686_((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), velocity, inaccuracy);
            }
            crossbowStack.m_41622_(1, shooter, livingEntity -> livingEntity.m_21190_(hand));
            level.m_7967_((Entity)projectile);
            level.m_6263_(null, shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, soundPitch);
        }
    }
}

