/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.entity.PalladiumEntityExtension;
import net.threetag.palladium.entity.TrailHandler;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.IntangibilityAbility;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public abstract class EntityMixin
implements PalladiumEntityExtension {
    @Unique
    private EntityPropertyHandler palladium$propertyHandler;
    @Unique
    private TrailHandler palladium$trailHandler;
    @Unique
    private Vec3 palladium$lastTickPos = Vec3.f_82478_;
    @Shadow
    public Level f_19853_;

    @Shadow
    public abstract Vec3 m_20182_();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    public void init(EntityType entityType, Level level, CallbackInfo ci) {
        this.palladium$propertyHandler = new EntityPropertyHandler((Entity)this);
        this.palladium$trailHandler = new TrailHandler((Entity)this);
        try {
            this.palladium$lastTickPos = this.m_20182_();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Inject(method={"load"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    public void load(CompoundTag compound, CallbackInfo ci) {
        CompoundTag palladiumTag;
        CompoundTag compoundTag = palladiumTag = compound.m_128441_("Palladium") ? compound.m_128469_("Palladium") : new CompoundTag();
        if (palladiumTag.m_128425_("Properties", 10)) {
            this.palladium$propertyHandler.fromNBT(palladiumTag.m_128469_("Properties"));
        }
    }

    @Inject(method={"saveWithoutId"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    public void saveWithoutId(CompoundTag compound, CallbackInfoReturnable<CompoundTag> ci) {
        CompoundTag palladiumTag = compound.m_128441_("Palladium") ? compound.m_128469_("Palladium") : new CompoundTag();
        palladiumTag.m_128365_("Properties", (Tag)this.palladium$propertyHandler.toNBT(true));
        compound.m_128365_("Palladium", (Tag)palladiumTag);
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/core/BlockPos;containing(DDD)Lnet/minecraft/core/BlockPos;")}, method={"moveTowardsClosestSpace"}, cancellable=true)
    protected void pushOutOfBlocks(double x, double y, double z, CallbackInfo ci) {
        EntityMixin entityMixin = this;
        if (entityMixin instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entityMixin;
            for (AbilityInstance entry : AbilityUtil.getEnabledInstances(living, (Ability)Abilities.INTANGIBILITY.get())) {
                if (!IntangibilityAbility.canGoThrough(entry, this.f_19853_.m_8055_(BlockPos.m_274561_((double)x, (double)y, (double)z)))) continue;
                ci.cancel();
                return;
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickPre(CallbackInfo ci) {
        this.palladium$lastTickPos = this.m_20182_();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void tickPost(CallbackInfo ci) {
        Entity entity = (Entity)this;
        if (entity.m_9236_().f_46443_ && !(entity instanceof LivingEntity)) {
            this.palladium$trailHandler.tick();
        }
    }

    @Override
    public EntityPropertyHandler palladium$getPropertyHandler() {
        return this.palladium$propertyHandler;
    }

    @Override
    public TrailHandler palladium$getTrailHandler() {
        return this.palladium$trailHandler;
    }

    @Override
    public Vec3 palladium$getLastTickPos() {
        return this.palladium$lastTickPos;
    }
}

