/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladiumcore.network.MessageC2S;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageType;

public class AbilityKeyPressedMessage
extends MessageC2S {
    private final AbilityReference reference;
    private final boolean pressed;

    public AbilityKeyPressedMessage(AbilityReference reference, boolean pressed) {
        this.reference = reference;
        this.pressed = pressed;
    }

    public AbilityKeyPressedMessage(FriendlyByteBuf buf) {
        this.reference = AbilityReference.fromBuffer(buf);
        this.pressed = buf.readBoolean();
    }

    public MessageType getType() {
        return PalladiumNetwork.ABILITY_KEY_PRESSED;
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.reference.toBuffer(buf);
        buf.writeBoolean(this.pressed);
    }

    public void handle(MessageContext context) {
        AbilityInstance instance = this.reference.getEntry((LivingEntity)context.getPlayer());
        if (instance != null && instance.isUnlocked()) {
            instance.keyPressed((LivingEntity)context.getPlayer(), this.pressed);
        }
    }
}

