/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;

public class SyncAbilityEntryPropertyMessage
extends MessageS2C {
    private final int entityId;
    private final AbilityReference reference;
    private final String propertyKey;
    private final CompoundTag tag;

    public SyncAbilityEntryPropertyMessage(int entityId, AbilityReference reference, String propertyKey, CompoundTag tag) {
        this.entityId = entityId;
        this.reference = reference;
        this.propertyKey = propertyKey;
        this.tag = tag;
    }

    public SyncAbilityEntryPropertyMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.reference = AbilityReference.fromBuffer(buf);
        this.propertyKey = buf.m_130277_();
        this.tag = buf.m_130260_();
    }

    public MessageType getType() {
        return PalladiumNetwork.SYNC_ABILITY_ENTRY_PROPERTY;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        this.reference.toBuffer(buf);
        buf.m_130070_(this.propertyKey);
        buf.m_130079_(this.tag);
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        PalladiumProperty<?> property;
        LivingEntity livingEntity;
        AbilityInstance entry;
        ClientLevel level = Objects.requireNonNull(Minecraft.m_91087_().f_91073_);
        Entity entity = level.m_6815_(this.entityId);
        if (entity instanceof LivingEntity && (entry = this.reference.getEntry(livingEntity = (LivingEntity)entity)) != null && (property = entry.getPropertyManager().getPropertyByName(this.propertyKey)) != null) {
            entry.getPropertyManager().setRaw(property, property.fromNBT(this.tag.m_128423_(property.getKey()), entry.getPropertyManager().getDefault(property)));
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof PowersScreen) {
                PowersScreen powers = (PowersScreen)screen;
                if (powers.selectedTab != null) {
                    powers.selectedTab.populate();
                }
            }
        }
    }
}

