/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;

public class SyncPropertyMessage
extends MessageS2C {
    private final int entityId;
    public final CompoundTag tag;

    public SyncPropertyMessage(int entityId, PalladiumProperty<?> property, Object value) {
        this.entityId = entityId;
        this.tag = new CompoundTag();
        if (value == null) {
            this.tag.m_128365_(property.getKey(), (Tag)StringTag.m_129297_((String)"null"));
        } else {
            PalladiumProperty<?> property1 = property;
            this.tag.m_128365_(property.getKey(), property1.toNBT(value));
        }
    }

    public SyncPropertyMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.tag = buf.m_130260_();
    }

    public MessageType getType() {
        return PalladiumNetwork.SYNC_PROPERTY;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_130079_(this.tag);
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        Entity entity = Objects.requireNonNull(Minecraft.m_91087_().f_91073_).m_6815_(this.entityId);
        if (entity != null) {
            EntityPropertyHandler.getHandler(entity).ifPresent(handler -> {
                for (String key : this.tag.m_128431_()) {
                    PalladiumProperty<?> property = handler.getPropertyByName(key);
                    if (property == null) continue;
                    handler.setRaw(property, property.fromNBT(this.tag.m_128423_(property.getKey()), handler.getDefault(property)));
                }
            });
        }
    }
}

