/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerHandler;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.energybar.EnergyBar;
import net.threetag.palladium.power.energybar.EnergyBarReference;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;
import org.apache.commons.lang3.tuple.Triple;
import org.jetbrains.annotations.NotNull;

public class UpdatePowersMessage
extends MessageS2C {
    private final int entityId;
    private final List<ResourceLocation> toRemove;
    private final List<ResourceLocation> toAdd;
    private final List<Triple<EnergyBarReference, Integer, Integer>> energyBars;

    public UpdatePowersMessage(LivingEntity livingEntity, List<ResourceLocation> toRemove, List<ResourceLocation> toAdd) {
        this.entityId = livingEntity.m_19879_();
        this.toRemove = toRemove;
        this.toAdd = toAdd;
        this.energyBars = new ArrayList<Triple<EnergyBarReference, Integer, Integer>>();
        Optional<PowerHandler> opt = PowerManager.getPowerHandler(livingEntity);
        if (opt.isPresent()) {
            for (IPowerHolder holder : opt.get().getPowerHolders().values()) {
                for (EnergyBar energyBar : holder.getEnergyBars().values()) {
                    this.energyBars.add((Triple<EnergyBarReference, Integer, Integer>)Triple.of((Object)new EnergyBarReference(holder.getPower().getId(), energyBar.getConfiguration().getName()), (Object)energyBar.get(), (Object)energyBar.getMax()));
                }
            }
        }
    }

    public UpdatePowersMessage(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.toRemove = buf.m_236845_(FriendlyByteBuf::m_130281_);
        this.toAdd = buf.m_236845_(FriendlyByteBuf::m_130281_);
        this.energyBars = buf.m_236845_(buf1 -> {
            EnergyBarReference ref = EnergyBarReference.fromBuffer(buf1);
            int val = buf1.readInt();
            int max = buf1.readInt();
            return Triple.of((Object)ref, (Object)val, (Object)max);
        });
    }

    @NotNull
    public MessageType getType() {
        return PalladiumNetwork.UPDATE_POWERS;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.m_236828_(this.toRemove, FriendlyByteBuf::m_130085_);
        buf.m_236828_(this.toAdd, FriendlyByteBuf::m_130085_);
        buf.m_236828_(this.energyBars, (buf1, pair) -> {
            ((EnergyBarReference)pair.getLeft()).toBuffer((FriendlyByteBuf)buf1);
            buf1.writeInt(((Integer)pair.getMiddle()).intValue());
            buf1.writeInt(((Integer)pair.getRight()).intValue());
        });
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        Entity entity;
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = level.m_6815_(this.entityId)) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            PowerManager manager = PowerManager.getInstance((Level)level);
            List<Power> toRemove = this.toRemove.stream().map(manager::getPower).filter(Objects::nonNull).toList();
            List<Power> toAdd = this.toAdd.stream().map(manager::getPower).filter(Objects::nonNull).toList();
            PowerManager.getPowerHandler(livingEntity).ifPresent(handler -> handler.removeAndAddPowers(toRemove, toAdd));
            for (Triple<EnergyBarReference, Integer, Integer> pair : this.energyBars) {
                EnergyBar bar = ((EnergyBarReference)pair.getLeft()).getEntry(livingEntity);
                if (bar == null) continue;
                bar.set((Integer)pair.getMiddle());
                bar.setMax((Integer)pair.getRight());
            }
        }
    }
}

