/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.util.property.ArmTypeProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.SyncType;

public class AimAbility
extends Ability
implements AnimationTimer {
    public static final PalladiumProperty<Integer> TIME = new IntegerProperty("time").configurable("Determines how many ticks it takes until the arm is fully aimed");
    public static final PalladiumProperty<ArmTypeProperty.ArmType> ARM = new ArmTypeProperty("arm").configurable("Determines which arm(s) should point");
    public static final PalladiumProperty<Integer> TIMER = new IntegerProperty("timer").sync(SyncType.NONE);
    public static final PalladiumProperty<Integer> PREV_TIMER = new IntegerProperty("prev_timer").sync(SyncType.NONE);

    public AimAbility() {
        this.withProperty(TIME, 10);
        this.withProperty(ARM, ArmTypeProperty.ArmType.MAIN_ARM);
    }

    @Override
    public void registerUniqueProperties(PropertyManager manager) {
        manager.register(TIMER, 0);
        manager.register(PREV_TIMER, 0);
    }

    @Override
    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (entity.m_9236_().f_46443_) {
            int timer = entry.getProperty(TIMER);
            entry.setUniqueProperty(PREV_TIMER, timer);
            if (enabled && timer < entry.getProperty(TIME)) {
                entry.setUniqueProperty(TIMER, timer + 1);
            } else if (!enabled && timer > 0) {
                entry.setUniqueProperty(TIMER, timer - 1);
            }
        }
    }

    public static float getTimer(LivingEntity entity, float partialTicks, boolean right) {
        float f = 0.0f;
        for (AbilityInstance entry : AbilityUtil.getEntries(entity, (Ability)Abilities.AIM.get())) {
            ArmTypeProperty.ArmType armType = entry.getProperty(ARM);
            if (armType.isNone()) continue;
            if (armType.isRight(entity) && right) {
                f = Math.max(f, Mth.m_14179_((float)partialTicks, (float)entry.getProperty(PREV_TIMER).intValue(), (float)entry.getProperty(TIMER).intValue()) / (float)entry.getProperty(TIME).intValue());
                continue;
            }
            if (!armType.isLeft(entity) || right) continue;
            f = Math.max(f, Mth.m_14179_((float)partialTicks, (float)entry.getProperty(PREV_TIMER).intValue(), (float)entry.getProperty(TIMER).intValue()) / (float)entry.getProperty(TIME).intValue());
        }
        return f;
    }

    @Override
    public String getDocumentationDescription() {
        return "Allows the player to aim their arms.";
    }

    @Override
    public float getAnimationValue(AbilityInstance entry, float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)entry.getProperty(PREV_TIMER).intValue(), (float)entry.getProperty(TIMER).intValue()) / (float)entry.getProperty(TIME).intValue();
    }

    @Override
    public float getAnimationTimer(AbilityInstance entry, float partialTick, boolean maxedOut) {
        if (maxedOut) {
            return entry.getProperty(TIME).intValue();
        }
        return Mth.m_14179_((float)partialTick, (float)entry.getProperty(PREV_TIMER).intValue(), (float)entry.getProperty(TIMER).intValue());
    }
}

