/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.energybar;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.network.SetEnergyBarMessage;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.energybar.EnergyBarConfiguration;
import net.threetag.palladium.power.energybar.EnergyBarReference;

public class EnergyBar {
    private final IPowerHolder powerHolder;
    private final EnergyBarConfiguration configuration;
    private int value;
    private int maxValue;
    private int overriddenMaxValue = -1;

    public EnergyBar(IPowerHolder powerHolder, EnergyBarConfiguration configuration) {
        this.powerHolder = powerHolder;
        this.configuration = configuration;
    }

    public void tick(LivingEntity entity) {
        if (this.configuration.getSyncedValue() != null) {
            int synced = this.configuration.getSyncedValue().get((Entity)entity);
            if (this.value != synced) {
                this.set(synced);
            }
        } else {
            int increase = this.configuration.getAutoIncrease();
            if (increase != 0 && entity.f_19797_ % this.configuration.getAutoIncreaseInterval() == 0) {
                this.add(increase);
            }
        }
        if (this.overriddenMaxValue > 0) {
            if (this.maxValue != this.overriddenMaxValue) {
                this.setMax(this.overriddenMaxValue);
            }
        } else {
            int syncedMax = this.configuration.getMaxValue().get((Entity)entity);
            if (this.maxValue != syncedMax) {
                this.setMax(syncedMax);
            }
        }
    }

    public void set(int value) {
        int prevValue = this.value;
        this.value = Mth.m_14045_((int)value, (int)0, (int)this.getMax());
        if (prevValue != this.value) {
            this.sync();
        }
    }

    public int get() {
        return this.value;
    }

    public int add(int value) {
        int prevValue = this.value;
        this.value = Mth.m_14045_((int)(this.value + value), (int)0, (int)this.getMax());
        if (prevValue != this.value) {
            this.sync();
        }
        return this.value;
    }

    public void setOverriddenMaxValue(int max) {
        int prev = this.overriddenMaxValue;
        this.overriddenMaxValue = Math.max(max, -1);
        if (prev != this.overriddenMaxValue) {
            if (this.value > this.getMax()) {
                this.value = this.getMax();
            }
            this.sync();
        }
    }

    public void setMax(int max) {
        int prevValue = this.maxValue;
        this.maxValue = Math.max(1, max);
        if (prevValue != this.value) {
            this.sync();
        }
    }

    public int getMax() {
        return this.maxValue;
    }

    public EnergyBarConfiguration getConfiguration() {
        return this.configuration;
    }

    private void sync() {
        if (!this.powerHolder.getEntity().m_9236_().f_46443_) {
            SetEnergyBarMessage msg = new SetEnergyBarMessage(this.powerHolder.getEntity().m_19879_(), new EnergyBarReference(this.powerHolder.getPower().getId(), this.configuration.getName()), this.value, this.maxValue);
            LivingEntity livingEntity = this.powerHolder.getEntity();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                msg.sendToTrackingAndSelf(player);
            } else {
                msg.sendToTracking((Entity)this.powerHolder.getEntity());
            }
        }
    }

    public CompoundTag toNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("Value", this.value);
        nbt.m_128405_("MaxValue", this.maxValue);
        nbt.m_128405_("OverriddenMaxValue", this.overriddenMaxValue);
        return nbt;
    }

    public void fromNBT(CompoundTag nbt) {
        this.set(nbt.m_128451_("Value"));
        this.setMax(nbt.m_128451_("MaxValue"));
        this.overriddenMaxValue = nbt.m_128451_("OverriddenMaxValue");
    }
}

