/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import org.slf4j.Logger;

public abstract class LegacySupportJsonReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String directory;
    private final String legacyDirectory;

    public LegacySupportJsonReloadListener(Gson gson, String directory, String legacyDirectory) {
        this.gson = gson;
        this.directory = directory;
        this.legacyDirectory = legacyDirectory;
    }

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap map = Maps.newHashMap();
        boolean foundLegacy = false;
        for (int m = 0; m < 2; ++m) {
            String path = m == 0 ? this.legacyDirectory : this.directory;
            int i = path.length() + 1;
            for (Map.Entry entry : resourceManager.m_214159_(path, p_215600_ -> p_215600_.m_135815_().endsWith(PATH_SUFFIX)).entrySet()) {
                if (m == 0) {
                    foundLegacy = true;
                }
                ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
                String s = resourcelocation.m_135815_();
                ResourceLocation id = new ResourceLocation(resourcelocation.m_135827_(), s.substring(i, s.length() - PATH_SUFFIX_LENGTH));
                try {
                    BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                    try {
                        JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class);
                        if (jsonelement != null) {
                            JsonElement jsonelement1 = map.put(id, jsonelement);
                            if (jsonelement1 == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(id));
                        }
                        LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)id, (Object)resourcelocation);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                    LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, resourcelocation, jsonparseexception});
                }
            }
        }
        if (foundLegacy) {
            AddonPackLog.warning("Files were found in deprecated folder: '" + this.legacyDirectory + "'. Please switch to '" + this.directory + "'!", new Object[0]);
        }
        return map;
    }
}

