/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import java.util.function.Predicate;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerUtil {
    public static boolean isCreativeFlying(LivingEntity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).m_150110_().f_35935_;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean hasSmallArms(Player player) {
        if (player instanceof AbstractClientPlayer) {
            return ((AbstractClientPlayer)player).m_108564_().equalsIgnoreCase("slim");
        }
        return false;
    }

    public static void playSound(Player player, double x, double y, double z, SoundEvent sound, SoundSource soundSource) {
        PlayerUtil.playSound(player, x, y, z, sound, soundSource, 1.0f, 1.0f);
    }

    public static void playSound(Player player, double x, double y, double z, SoundEvent sound, SoundSource soundSource, float volume, float pitch) {
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)sound), soundSource, x, y, z, volume, pitch, player.m_217043_().m_188505_()));
        }
    }

    public static void playSound(Player player, double x, double y, double z, ResourceLocation sound, SoundSource category) {
        PlayerUtil.playSound(player, x, y, z, sound, category, 1.0f, 1.0f);
    }

    public static void playSound(Player player, double x, double y, double z, ResourceLocation sound, SoundSource category, float volume, float pitch) {
        if (player instanceof ServerPlayer) {
            ((ServerPlayer)player).f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)((SoundEvent)BuiltInRegistries.f_256894_.m_7745_(sound))), category, x, y, z, volume, pitch, player.m_217043_().m_188505_()));
        }
    }

    public static void playSoundToAll(Level world, double x, double y, double z, double range, SoundEvent sound, SoundSource category) {
        PlayerUtil.playSoundToAll(world, x, y, z, range, sound, category, 1.0f, 1.0f);
    }

    public static void playSoundToAll(Level world, double x, double y, double z, double range, SoundEvent sound, SoundSource category, float volume, float pitch) {
        AABB a = new AABB(BlockPos.m_274561_((double)(x - range), (double)(y - range), (double)(z - range)), BlockPos.m_274561_((double)(x + range), (double)(y + range), (double)(z + range)));
        for (Player players : world.m_45976_(Player.class, a)) {
            PlayerUtil.playSound(players, x, y, z, sound, category, volume, pitch);
        }
    }

    public static void playSoundToAll(Level world, double x, double y, double z, double range, ResourceLocation sound, SoundSource category) {
        PlayerUtil.playSoundToAll(world, x, y, z, range, sound, category, 1.0f, 1.0f);
    }

    public static void playSoundToAll(Level world, double x, double y, double z, double range, ResourceLocation sound, SoundSource category, float volume, float pitch) {
        AABB a = new AABB(BlockPos.m_274561_((double)(x - range), (double)(y - range), (double)(z - range)), BlockPos.m_274561_((double)(x + range), (double)(y + range), (double)(z + range)));
        for (Player players : world.m_45976_(Player.class, a)) {
            PlayerUtil.playSound(players, x, y, z, sound, category, volume, pitch);
        }
    }

    public static void playSoundToAll(Level world, double x, double y, double z, double range, ResourceLocation sound, SoundSource category, float volume, float pitch, Predicate<Player> playerPredicate) {
        AABB a = new AABB(BlockPos.m_274561_((double)(x - range), (double)(y - range), (double)(z - range)), BlockPos.m_274561_((double)(x + range), (double)(y + range), (double)(z + range)));
        for (Player players : world.m_45976_(Player.class, a)) {
            if (!playerPredicate.test(players)) continue;
            PlayerUtil.playSound(players, x, y, z, sound, category, volume, pitch);
        }
    }

    public static <T extends ParticleOptions> void spawnParticle(Player player, T particleIn, boolean longDistanceIn, double xIn, double yIn, double zIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, float speedIn, int countIn) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundLevelParticlesPacket(particleIn, longDistanceIn, xIn, yIn, zIn, xOffsetIn, yOffsetIn, zOffsetIn, speedIn, countIn));
        }
    }

    public static <T extends ParticleOptions> void spawnParticleForAll(Level world, double range, T particleIn, boolean longDistanceIn, double xIn, double yIn, double zIn, float xOffsetIn, float yOffsetIn, float zOffsetIn, float speedIn, int countIn) {
        AABB a = new AABB(BlockPos.m_274561_((double)(xIn - range), (double)(yIn - range), (double)(zIn - range)), BlockPos.m_274561_((double)(xIn + range), (double)(yIn + range), (double)(zIn + range)));
        for (Player players : world.m_45976_(Player.class, a)) {
            PlayerUtil.spawnParticle(players, particleIn, longDistanceIn, xIn, yIn, zIn, xOffsetIn, yOffsetIn, zOffsetIn, speedIn, countIn);
        }
    }
}

