/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.icon;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.GuiUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.icon.IconSerializers;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.NotNull;

public class ItemIcon
implements IIcon {
    public final ItemStack stack;

    public ItemIcon(ItemStack stack) {
        this.stack = stack;
    }

    public ItemIcon(ItemLike itemLike) {
        this.stack = new ItemStack(itemLike);
    }

    @Override
    public void draw(Minecraft mc, GuiGraphics guiGraphics, DataContext context, int x, int y, int width, int height) {
        ItemStack item;
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_85837_((double)x + (double)width / 2.0, (double)y + (double)height / 2.0, 100.0);
        if (width != 16 || height != 16) {
            int s = Math.min(width, height);
            guiGraphics.m_280168_().m_85841_((float)s / 16.0f, (float)s / 16.0f, (float)s / 16.0f);
        }
        if ((item = this.stack).m_41619_()) {
            ItemStack contextItem = context.getItem();
            item = !contextItem.m_41619_() ? contextItem : new ItemStack((ItemLike)Items.f_42127_);
        }
        GuiUtil.drawItem(guiGraphics, item, 0, true, null);
        guiGraphics.m_280168_().m_85849_();
    }

    public IconSerializer<ItemIcon> getSerializer() {
        return (IconSerializer)IconSerializers.ITEM.get();
    }

    public String toString() {
        return "ItemIcon{stack=" + String.valueOf(this.stack) + "}";
    }

    public static class Serializer
    extends IconSerializer<ItemIcon> {
        @Override
        @NotNull
        public ItemIcon fromJSON(JsonObject json) {
            return new ItemIcon(json.has("item") ? GsonUtil.readItemStack((JsonElement)json) : ItemStack.f_41583_);
        }

        @Override
        public ItemIcon fromNBT(CompoundTag nbt) {
            return new ItemIcon(ItemStack.m_41712_((CompoundTag)nbt));
        }

        @Override
        public JsonObject toJSON(ItemIcon icon) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)icon.stack.m_41720_()).toString());
            jsonObject.addProperty("count", (Number)icon.stack.m_41613_());
            return jsonObject;
        }

        @Override
        public CompoundTag toNBT(ItemIcon icon) {
            return icon.stack.m_41739_(new CompoundTag());
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Item Icon");
            builder.setDescription("Uses an item as an icon.");
            builder.addProperty("item", ResourceLocation.class).description("ID of the item that's supposed to be displayed. If you leave it out, it will display the item from the current context (if given).").fallback(new ResourceLocation("minecraft:air")).exampleJson((JsonElement)new JsonPrimitive("minecraft:apple"));
        }
    }
}

