/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.threetag.palladium.util.property.PalladiumProperty;

public class BooleanProperty
extends PalladiumProperty<Boolean> {
    public BooleanProperty(String key) {
        super(key);
    }

    @Override
    public Boolean fromJSON(JsonElement jsonElement) {
        return jsonElement.getAsBoolean();
    }

    @Override
    public JsonElement toJSON(Boolean value) {
        return new JsonPrimitive(value);
    }

    @Override
    public Boolean fromNBT(Tag tag, Boolean defaultValue) {
        if (tag instanceof ByteTag) {
            ByteTag byteTag = (ByteTag)tag;
            return byteTag.m_7063_() != 0;
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(Boolean value) {
        return ByteTag.m_128273_((boolean)value);
    }

    @Override
    public Boolean fromBuffer(FriendlyByteBuf buf) {
        return buf.readBoolean();
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.writeBoolean(((Boolean)value).booleanValue());
    }

    @Override
    public String getPropertyType() {
        return "boolean";
    }
}

