/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.IconSerializer;
import net.threetag.palladium.util.property.PalladiumProperty;

public class IconProperty
extends PalladiumProperty<IIcon> {
    public IconProperty(String key) {
        super(key);
    }

    @Override
    public IIcon fromJSON(JsonElement jsonElement) {
        return IconSerializer.parseJSON(jsonElement);
    }

    @Override
    public JsonElement toJSON(IIcon value) {
        return IconSerializer.serializeJSON(value);
    }

    @Override
    public IIcon fromNBT(Tag tag, IIcon defaultValue) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return IconSerializer.parseNBT(compoundTag);
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(IIcon value) {
        return IconSerializer.serializeNBT(value);
    }

    @Override
    public IIcon fromBuffer(FriendlyByteBuf buf) {
        return IconSerializer.parseNBT(Objects.requireNonNull(buf.m_130260_()));
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.m_130079_(IconSerializer.serializeNBT((IIcon)value));
    }

    @Override
    public String getPropertyType() {
        return "icon";
    }
}

