/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladium.util.property.PalladiumProperty;

public class TagKeyListProperty<T>
extends PalladiumProperty<List<TagKey<T>>> {
    private final ResourceKey<Registry<T>> registry;

    public TagKeyListProperty(String key, ResourceKey<Registry<T>> registry) {
        super(key);
        this.registry = registry;
    }

    @Override
    public List<TagKey<T>> fromJSON(JsonElement jsonElement) {
        return GsonUtil.fromListOrPrimitive(jsonElement, j -> TagKey.m_203882_(this.registry, (ResourceLocation)new ResourceLocation(j.getAsString())));
    }

    @Override
    public JsonElement toJSON(List<TagKey<T>> value) {
        if (value.size() == 1) {
            return new JsonPrimitive(value.get(0).f_203868_().toString());
        }
        JsonArray array = new JsonArray();
        for (TagKey<T> tag : value) {
            array.add((JsonElement)new JsonPrimitive(tag.f_203868_().toString()));
        }
        return array;
    }

    @Override
    public List<TagKey<T>> fromNBT(Tag tag, List<TagKey<T>> defaultValue) {
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            ArrayList<TagKey<T>> list = new ArrayList<TagKey<T>>();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(TagKey.m_203882_(this.registry, (ResourceLocation)new ResourceLocation(listTag.m_128778_(i))));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(List<TagKey<T>> value) {
        ListTag listTag = new ListTag();
        for (TagKey<T> tag : value) {
            listTag.add((Object)StringTag.m_129297_((String)tag.f_203868_().toString()));
        }
        return listTag;
    }

    @Override
    public List<TagKey<T>> fromBuffer(FriendlyByteBuf buf) {
        ArrayList<TagKey<T>> list = new ArrayList<TagKey<T>>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            list.add(TagKey.m_203882_(this.registry, (ResourceLocation)buf.m_130281_()));
        }
        return list;
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        List list = (List)value;
        buf.writeInt(list.size());
        for (TagKey tag : list) {
            buf.m_130085_(tag.f_203868_());
        }
    }

    @Override
    public String getString(List<TagKey<T>> value) {
        return value == null ? null : Arrays.toString(value.stream().map(t -> t.f_203868_().toString()).toArray());
    }

    @Override
    public String getPropertyType() {
        return "tag_key_list";
    }
}

