/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;

public class PalladiumMixinPlugin
implements IMixinConfigPlugin {
    private static final boolean HAS_KUBEJS = PalladiumMixinPlugin.hasClass("dev.latvian.mods.kubejs.KubeJS");
    private static final boolean HAS_TRINKETS = PalladiumMixinPlugin.hasClass("dev.emi.trinkets.api.TrinketsApi");
    private static final boolean HAS_CURIOS = PalladiumMixinPlugin.hasClass("top.theillusivec4.curios.api.CuriosApi");
    private static final boolean HAS_GECKO = PalladiumMixinPlugin.hasClass("software.bernie.geckolib.renderer.GeoArmorRenderer");
    public static final boolean HAS_QUILT = PalladiumMixinPlugin.hasClass("org.quiltmc.qsl.resource.loader.impl.ResourceLoaderImpl");
    public static final boolean HAS_SODIUM = PalladiumMixinPlugin.hasClass("net.caffeinemc.mods.sodium.client.render.immediate.model.EntityRenderer");

    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        try {
            if (mixinClassName.equalsIgnoreCase("net.threetag.palladium.mixin.ScriptFileInfoMixin") || mixinClassName.equalsIgnoreCase("net.threetag.palladium.mixin.ScriptManagerMixin")) {
                return HAS_KUBEJS;
            }
            if (mixinClassName.equalsIgnoreCase("net.threetag.palladium.mixin.fabric.TrinketsApiMixin")) {
                return HAS_TRINKETS;
            }
            if (mixinClassName.equalsIgnoreCase("net.threetag.palladium.mixin.client.GeoArmorRendererMixin") || mixinClassName.equalsIgnoreCase("net.threetag.palladium.mixin.client.GeoArmorRendererInvoker") || mixinClassName.equalsIgnoreCase("net.threetag.palladium.mixin.client.GeoRendererMixin")) {
                return HAS_GECKO;
            }
            if (mixinClassName.equalsIgnoreCase("net.threetag.palladium.mixin.fabric.ResourceLoaderImplMixin")) {
                return HAS_QUILT;
            }
            if (mixinClassName.equalsIgnoreCase("net.threetag.palladium.mixin.client.SodiumFixMixin")) {
                return HAS_SODIUM;
            }
        }
        catch (Exception ignored) {
            return true;
        }
        return true;
    }

    private static boolean hasClass(String name) {
        try {
            MixinService.getService().getBytecodeProvider().getClassNode(name);
            return true;
        }
        catch (IOException | ClassNotFoundException e) {
            return false;
        }
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

