/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.accessory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1007;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3879;
import net.minecraft.class_3883;
import net.minecraft.class_4013;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5599;
import net.minecraft.class_591;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.accessory.AccessoryPlayerData;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.SupporterHandler;
import net.threetag.palladiumcore.registry.PalladiumRegistry;
import net.threetag.palladiumcore.util.Platform;
import org.jetbrains.annotations.Nullable;

public abstract class Accessory {
    public static final PalladiumRegistry<Accessory> REGISTRY = PalladiumRegistry.create(Accessory.class, (class_2960)Palladium.id("accessories"));
    private boolean exclusive = false;

    public boolean isAvailable(class_1657 entity) {
        return this.isAvailable(SupporterHandler.getPlayerData(entity.method_5667()));
    }

    public boolean isAvailable(SupporterHandler.PlayerData data) {
        return !this.exclusive || !Platform.isProduction() || data.hasAccessory(this);
    }

    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)class_156.method_646((String)"accessory", (class_2960)REGISTRY.getKey((Object)this)));
    }

    public String toString() {
        return REGISTRY.getKey((Object)this).toString();
    }

    public Accessory setExclusive() {
        this.exclusive = true;
        return this;
    }

    @Environment(value=EnvType.CLIENT)
    public void onReload(class_5599 entityModelSet) {
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_3883<class_742, class_591<class_742>> renderLayerParent, AccessorySlot slot, class_4587 poseStack, class_4597 bufferSource, int packedLightIn, class_742 player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    @Environment(value=EnvType.CLIENT)
    public void renderArm(class_1306 arm, class_742 player, class_1007 playerRenderer, class_630 armPart, class_630 armWearPart, AccessorySlot slot, class_4587 poseStack, class_4597 bufferSource, int packedLight) {
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isVisible(AccessorySlot slot, class_742 player, boolean isFirstPerson) {
        return (slot.getCorrespondingEquipmentSlot() == null || player.method_6118(slot.getCorrespondingEquipmentSlot()).method_7960()) && !slot.wasHidden((class_1657)player, isFirstPerson);
    }

    @Environment(value=EnvType.CLIENT)
    public boolean canRenderAsArm(AccessorySlot slot, class_1306 arm, class_742 player) {
        if (player.method_6068() == class_1306.field_6183) {
            if (slot == AccessorySlot.MAIN_ARM || slot == AccessorySlot.MAIN_HAND) {
                return arm == class_1306.field_6183;
            }
            if (slot == AccessorySlot.OFF_ARM || slot == AccessorySlot.OFF_HAND) {
                return arm == class_1306.field_6182;
            }
        } else {
            if (slot == AccessorySlot.MAIN_ARM || slot == AccessorySlot.MAIN_HAND) {
                return arm == class_1306.field_6182;
            }
            if (slot == AccessorySlot.OFF_ARM || slot == AccessorySlot.OFF_HAND) {
                return arm == class_1306.field_6183;
            }
        }
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public static class_630 getArm(class_591<?> model, boolean mainHand, class_1306 primaryHand) {
        if (mainHand) {
            return primaryHand == class_1306.field_6183 ? model.field_3401 : model.field_27433;
        }
        return primaryHand == class_1306.field_6183 ? model.field_27433 : model.field_3401;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_1921 getRenderType(class_742 player, class_2960 resourceLocation, class_3879 model) {
        boolean flag1;
        boolean flag = !player.method_5767();
        boolean bl = flag1 = !flag && !player.method_5756((class_1657)class_310.method_1551().field_1724);
        if (flag1) {
            return class_1921.method_23580((class_2960)resourceLocation);
        }
        if (flag) {
            return model.method_23500(resourceLocation);
        }
        return class_310.method_1551().method_27022((class_1297)player) ? class_1921.method_23287((class_2960)resourceLocation) : null;
    }

    public abstract Collection<AccessorySlot> getPossibleSlots();

    public static List<Accessory> getAvailableAccessories(SupporterHandler.PlayerData data) {
        ArrayList<Accessory> list = new ArrayList<Accessory>();
        for (Accessory accessory : REGISTRY.getValues()) {
            if (!accessory.isAvailable(data)) continue;
            list.add(accessory);
        }
        return list;
    }

    public static List<Accessory> getAvailableAccessories(SupporterHandler.PlayerData data, AccessorySlot slot) {
        ArrayList<Accessory> list = new ArrayList<Accessory>();
        for (Accessory accessory : REGISTRY.getValues()) {
            if (!accessory.getPossibleSlots().contains(slot) || !accessory.isAvailable(data)) continue;
            list.add(accessory);
        }
        return list;
    }

    public static Optional<AccessoryPlayerData> getPlayerData(class_1657 player) {
        if (player instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension ext = (PalladiumPlayerExtension)player;
            return Optional.of(ext.palladium$getAccessories());
        }
        return Optional.empty();
    }

    public static class ReloadManager
    implements class_4013 {
        public void method_14491(class_3300 resourceManager) {
            for (Accessory accessory : REGISTRY.getValues()) {
                accessory.onReload(class_310.method_1551().method_31974());
            }
        }
    }
}

