/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.builder;

import com.google.gson.JsonObject;
import net.minecraft.class_2248;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.BlockParser;
import net.threetag.palladium.block.AddonBlock;
import net.threetag.palladium.block.IAddonBlock;

public class BlockBuilder
extends AddonBuilder<class_2248> {
    private final JsonObject json;
    private class_2960 typeSerializerId = null;
    private class_3620 mapColor;
    private class_2498 soundType;
    private float destroyTime;
    private float explosionResistance;
    private boolean noOcclusion = false;
    private boolean requiresCorrectToolForDrops = false;
    private String renderType = null;

    public BlockBuilder(class_2960 id, JsonObject json) {
        super(id);
        this.json = json;
    }

    @Override
    protected class_2248 create() {
        BlockParser.BlockTypeSerializer serializer;
        class_4970.class_2251 properties = class_4970.class_2251.method_9637().method_31710(this.mapColor).method_9629(this.destroyTime, this.explosionResistance);
        if (this.soundType != null) {
            properties.method_9626(this.soundType);
        }
        if (this.noOcclusion) {
            properties.method_22488();
        }
        if (this.requiresCorrectToolForDrops) {
            properties.method_29292();
        }
        if (this.typeSerializerId == null) {
            this.typeSerializerId = BlockParser.FALLBACK_SERIALIZER;
        }
        if ((serializer = BlockParser.getTypeSerializer(this.typeSerializerId)) == null) {
            AddonPackLog.warning("Unknown block type '" + String.valueOf(this.typeSerializerId) + "', falling back to '" + String.valueOf(BlockParser.FALLBACK_SERIALIZER) + "'", new Object[0]);
        }
        IAddonBlock block = serializer != null ? serializer.parse(this.json, properties) : new AddonBlock(properties);
        block.setRenderType(this.renderType);
        return (class_2248)block;
    }

    public BlockBuilder type(class_2960 serializerId) {
        this.typeSerializerId = serializerId;
        return this;
    }

    public BlockBuilder mapColor(class_3620 color) {
        this.mapColor = color;
        return this;
    }

    public BlockBuilder soundType(class_2498 soundType) {
        this.soundType = soundType;
        return this;
    }

    public BlockBuilder destroyTime(float destroyTime) {
        this.destroyTime = destroyTime;
        return this;
    }

    public BlockBuilder explosionResistance(float explosionResistance) {
        this.explosionResistance = explosionResistance;
        return this;
    }

    public BlockBuilder renderType(String name) {
        this.renderType = name;
        return this;
    }

    public BlockBuilder noOcclusion() {
        this.noOcclusion = true;
        return this;
    }

    public BlockBuilder requiresCorrectToolForDrops() {
        this.requiresCorrectToolForDrops = true;
        return this;
    }
}

