/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.builder;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import org.jetbrains.annotations.Nullable;

public class ParticleTypeBuilder
extends AddonBuilder<class_2396<?>> {
    private boolean overrideLimiter = false;
    private RenderType renderType = RenderType.PARTICLE_SHEET_OPAQUE;
    private TextureType textureType = TextureType.RANDOM;
    private int lifetime = 100;
    private boolean hasPhysics = true;
    private float gravity = 0.02f;
    private float quadSize = 1.0f;
    private int brightness = -1;

    public ParticleTypeBuilder(class_2960 id) {
        super(id);
    }

    @Override
    protected class_2396<?> create() {
        return new class_2400(this.overrideLimiter);
    }

    public ParticleTypeBuilder enableOverrideLimiter(boolean overrideLimiter) {
        this.overrideLimiter = overrideLimiter;
        return this;
    }

    public ParticleTypeBuilder renderType(RenderType renderType) {
        this.renderType = renderType;
        return this;
    }

    public ParticleTypeBuilder textureType(TextureType textureType) {
        this.textureType = textureType;
        return this;
    }

    public ParticleTypeBuilder lifetime(int lifetime) {
        this.lifetime = lifetime;
        return this;
    }

    public ParticleTypeBuilder hasPhysics(boolean hasPhysics) {
        this.hasPhysics = hasPhysics;
        return this;
    }

    public ParticleTypeBuilder gravity(float gravity) {
        this.gravity = gravity;
        return this;
    }

    public ParticleTypeBuilder quadSize(float quadSize) {
        this.quadSize = quadSize;
        return this;
    }

    public ParticleTypeBuilder brightness(int brightness) {
        this.brightness = brightness;
        return this;
    }

    public static enum RenderType {
        TERRAIN_SHEET("terrain_sheet"),
        PARTICLE_SHEET_OPAQUE("opaque"),
        PARTICLE_SHEET_TRANSLUCENT("translucent"),
        PARTICLE_SHEET_LIT("lit"),
        NO_RENDER("no_render");

        private final String name;

        private RenderType(String name) {
            this.name = name;
        }

        public static RenderType byName(String name) {
            for (RenderType value : RenderType.values()) {
                if (!value.name.equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }

    public static enum TextureType {
        RANDOM("random"),
        AGING("aging");

        private final String name;

        private TextureType(String name) {
            this.name = name;
        }

        public static TextureType byName(String name) {
            for (TextureType value : TextureType.values()) {
                if (!value.name.equalsIgnoreCase(name)) continue;
                return value;
            }
            return null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Provider
    implements class_707<class_2400> {
        private final ParticleTypeBuilder builder;
        private final class_4002 sprite;

        public Provider(ParticleTypeBuilder builder, class_4002 sprite) {
            this.builder = builder;
            this.sprite = sprite;
        }

        @Nullable
        public class_703 createParticle(class_2400 type, class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new Particle(level, this.sprite, x, y, z, xSpeed, ySpeed, zSpeed, this.builder);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class Particle
    extends class_4003 {
        private final ParticleTypeBuilder builder;
        private final class_4002 spriteSet;

        protected Particle(class_638 clientLevel, class_4002 spriteSet, double x, double y, double z, double xd, double yd, double zd, ParticleTypeBuilder builder) {
            super(clientLevel, x, y, z, xd, yd, zd);
            this.method_34753(xd, yd, zd);
            this.builder = builder;
            this.spriteSet = spriteSet;
            this.field_3847 = this.builder.lifetime;
            this.field_3862 = this.builder.hasPhysics;
            this.field_3844 = this.builder.gravity;
            this.field_17867 = this.builder.quadSize;
            if (this.field_3844 == 0.0f) {
                this.method_34753(0.0, 0.0, 0.0);
            }
            if (this.builder.textureType == TextureType.RANDOM) {
                this.method_18140(this.spriteSet);
            } else if (this.builder.textureType == TextureType.AGING) {
                this.method_18142(this.spriteSet);
            }
        }

        public void method_3070() {
            super.method_3070();
            if (this.builder.textureType == TextureType.AGING) {
                this.method_18142(this.spriteSet);
            }
        }

        public int method_3068(float partialTick) {
            if (this.builder.brightness < 0) {
                return super.method_3068(partialTick);
            }
            int i = super.method_3068(partialTick);
            int k = i >> 16 & 0xFF;
            return this.builder.brightness | k << 16;
        }

        public class_3999 method_18122() {
            switch (this.builder.renderType) {
                case NO_RENDER: {
                    return class_3999.field_17832;
                }
                case PARTICLE_SHEET_LIT: {
                    return class_3999.field_17830;
                }
                case PARTICLE_SHEET_OPAQUE: {
                    return class_3999.field_17828;
                }
                case PARTICLE_SHEET_TRANSLUCENT: {
                    return class_3999.field_17829;
                }
                case TERRAIN_SHEET: {
                    return class_3999.field_17827;
                }
            }
            return class_3999.field_17832;
        }
    }
}

