/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.log;

import java.util.Arrays;
import net.minecraft.class_124;
import org.apache.logging.log4j.message.Message;

public class AddonPackLogEntry {
    private final Type type;
    private Message msg;
    private String msgString;
    private final String stacktrace;

    public AddonPackLogEntry(Type type, Message message) {
        this(type, message, null);
    }

    public AddonPackLogEntry(Type type, Message message, StackTraceElement[] stacktrace) {
        this.type = type;
        this.msg = message;
        this.stacktrace = Arrays.toString(stacktrace);
    }

    public AddonPackLogEntry(Type type, String msgString) {
        this(type, msgString, null);
    }

    public AddonPackLogEntry(Type type, String msgString, StackTraceElement[] stacktrace) {
        this.type = type;
        this.msgString = msgString;
        this.stacktrace = Arrays.toString(stacktrace);
    }

    public Type getType() {
        return this.type;
    }

    public String getText() {
        return this.msg != null ? this.msg.getFormattedMessage() : this.msgString;
    }

    public String getStacktrace() {
        return this.stacktrace;
    }

    public String toString() {
        return "[" + this.type.toString() + "] " + String.valueOf(this.msg != null ? this.msg : this.msgString);
    }

    public static enum Type {
        INFO(class_124.field_1070),
        WARNING(class_124.field_1054),
        ERROR(class_124.field_1061);

        private final class_124 color;

        private Type(class_124 color) {
            this.color = color;
        }

        public class_124 getColor() {
            return this.color;
        }
    }
}

