/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.accessory.DefaultAccessory;
import net.threetag.palladium.accessory.HumanoidModelOverlayAccessory;
import net.threetag.palladium.accessory.OverlayAccessory;
import net.threetag.palladium.accessory.RenderLayerAccessory;
import net.threetag.palladium.addonpack.builder.AccessoryBuilder;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.IDocumentedConfigurable;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;

public class AccessoryParser
extends AddonParser<Accessory> {
    private static final Map<class_2960, TypeSerializer> TYPE_SERIALIZERS = new LinkedHashMap<class_2960, TypeSerializer>();

    public AccessoryParser() {
        super(GSON, "accessories", Accessory.REGISTRY.getRegistryKey());
    }

    @Override
    public AddonBuilder<Accessory> parse(class_2960 id, JsonElement jsonElement) {
        JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"$");
        AccessoryBuilder builder = new AccessoryBuilder(id, json);
        builder.type(TYPE_SERIALIZERS.get(GsonUtil.getAsResourceLocation(json, "type", null)));
        JsonElement slotJson = json.get("slot");
        if (slotJson.isJsonPrimitive()) {
            builder.addSlot(AccessorySlot.getSlotByName(GsonUtil.getAsResourceLocation(json, "slot")));
        } else if (slotJson.isJsonArray()) {
            JsonArray array = class_3518.method_15261((JsonObject)json, (String)"slot");
            for (JsonElement element : array) {
                builder.addSlot(AccessorySlot.getSlotByName(GsonUtil.convertToResourceLocation(element, "slot[].$")));
            }
        }
        return builder;
    }

    public static void registerTypeSerializer(TypeSerializer serializer) {
        TYPE_SERIALIZERS.put(serializer.getId(), serializer);
    }

    public static HTMLBuilder documentationBuilder() {
        return new HTMLBuilder(new class_2960("palladium", "accessories"), "Accessories").add(HTMLBuilder.heading("Accessories")).addDocumentationSettings(new ArrayList<IDocumentedConfigurable>(TYPE_SERIALIZERS.values()));
    }

    public static void addSlotDocumentation(JsonDocumentationBuilder builder) {
        builder.addProperty("slot", class_2960.class).description("ID of the slot the accessory will be in. Can be one or many. Possible values: " + Arrays.toString(AccessorySlot.getSlots().stream().map(AccessorySlot::getName).toArray())).required().exampleJson((JsonElement)new JsonPrimitive("palladium:head"));
    }

    static {
        AccessoryParser.registerTypeSerializer(new DefaultAccessory.Serializer());
        AccessoryParser.registerTypeSerializer(new RenderLayerAccessory.Serializer());
        AccessoryParser.registerTypeSerializer(new OverlayAccessory.Serializer());
        AccessoryParser.registerTypeSerializer(new HumanoidModelOverlayAccessory.Serializer());
    }

    public static interface TypeSerializer
    extends IDocumentedConfigurable {
        public DefaultAccessory parse(JsonObject var1);
    }
}

