/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladiumcore.event.LifecycleEvents;

public class AccessorySlotParser
extends class_4309 {
    public AccessorySlotParser() {
        super(AddonParser.GSON, "accessory_slots");
    }

    protected void apply(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler) {
        AtomicInteger i = new AtomicInteger();
        object.forEach((id, jsonElement) -> {
            try {
                JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"$");
                class_2960 icon = GsonUtil.getAsResourceLocation(json, "icon");
                AccessorySlot slot = AccessorySlot.register(id).setIcon(icon);
                if (class_3518.method_15258((JsonObject)json, (String)"allows_multiple", (boolean)false)) {
                    slot.allowMultiple();
                }
                if (json.has("menu_visibility")) {
                    LifecycleEvents.CLIENT_SETUP.register(() -> ConditionSerializer.listFromJSON(json.get("menu_visibility"), ConditionEnvironment.ASSETS).forEach(slot::addVisibilityCondition));
                }
                if (json.has("sort_index")) {
                    slot.setSortIndex(class_3518.method_15260((JsonObject)json, (String)"sort_index"));
                }
                i.getAndIncrement();
            }
            catch (Exception e) {
                class_128 crashReport = class_128.method_560((Throwable)e, (String)("Error while parsing addonpack creative mode tab  '" + String.valueOf(id) + "'"));
                class_129 reportCategory = crashReport.method_556("Addon Creative Mode Tab", 1);
                reportCategory.method_578("Resource name", id);
                throw new class_148(crashReport);
            }
        });
        AddonPackLog.info("Registered " + i.get() + " addonpack accessory slots", new Object[0]);
    }

    public static HTMLBuilder documentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder().setDescription("Each accessory slot goes into a seperate file into the 'addon/[namespace]/accessory_slots' folder, which can then be used for accessories.");
        builder.addProperty("icon", class_2960.class).description("Texture path for the icon of the slot.").required().exampleJson((JsonElement)new JsonPrimitive("namespace:textures/gui/accessory_slots/example.png"));
        builder.addProperty("allows_multiple", Boolean.class).description("Determines if multiple accessories in this slot can be equipped").fallback(false).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
        builder.addProperty("menu_visibility", Condition[].class).description("Determines if the slot is visible in the menu. Can be ignored, set to 'false' or defined by conditions").fallback(null).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        return new HTMLBuilder(new class_2960("palladium", "accessory_slots"), "Accessory Slots").add(HTMLBuilder.heading("Accessory Slots")).addDocumentation(builder);
    }
}

