/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.List;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_7924;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.builder.CreativeModeTabBuilder;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.json.GsonUtil;

public class CreativeModeTabParser
extends AddonParser<class_1761> {
    public CreativeModeTabParser() {
        super(AddonParser.GSON, "creative_mode_tabs", class_7924.field_44688);
    }

    @Override
    public AddonBuilder<class_1761> parse(class_2960 id, JsonElement jsonElement) {
        JsonObject json = class_3518.method_15295((JsonElement)jsonElement, (String)"$");
        CreativeModeTabBuilder builder = new CreativeModeTabBuilder(id);
        builder.itemIconId(GsonUtil.getAsResourceLocation(json, "icon"));
        if (class_3518.method_15294((JsonObject)json, (String)"title")) {
            builder.title((class_2561)class_2561.class_2562.method_10872((JsonElement)json.get("title")));
        }
        if (class_3518.method_15294((JsonObject)json, (String)"items")) {
            JsonArray array = class_3518.method_15261((JsonObject)json, (String)"items");
            for (JsonElement element : array) {
                builder.addItem(GsonUtil.convertToResourceLocation(element, "items[].$"));
            }
        }
        return builder;
    }

    public static HTMLBuilder documentationBuilder() {
        JsonDocumentationBuilder builder = new JsonDocumentationBuilder().setDescription("Each creative mode tab goes into a seperate file into the 'addon/[namespace]/creative_mode_tabs' folder, which can then be used for items.");
        builder.addProperty("icon", class_1792.class).description("Icon for tab, can only be an item.").required().exampleJson((JsonElement)new JsonPrimitive("minecraft:trident"));
        builder.addProperty("title", class_2561.class).description("Custom title for the tab. Will fall back to a translation key based on the ID.").fallback(null).exampleJson((JsonElement)new JsonPrimitive("itemGroup.namespace.example"));
        JsonArray jsonArray = new JsonArray();
        jsonArray.add("minecraft:cactus");
        jsonArray.add("minecraft:bread");
        jsonArray.add("minecraft:stick");
        builder.addProperty("items", List.class).description("You can list your items for the tab in the correct order here.").fallback(null).exampleJson((JsonElement)jsonArray);
        return new HTMLBuilder(new class_2960("palladium", "creative_mode_tabs"), "Creative Mode Tabs").add(HTMLBuilder.heading("Creative Mode Tabs")).addDocumentation(builder);
    }
}

